/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.fsx.model.CreateOntapVolumeConfiguration;
import com.amazonaws.services.fsx.model.CreateOpenZFSVolumeConfiguration;
import com.amazonaws.services.fsx.model.Tag;
import com.amazonaws.services.fsx.model.VolumeType;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateVolumeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clientRequestToken;
    private String volumeType;
    private String name;
    private CreateOntapVolumeConfiguration ontapConfiguration;
    private List<Tag> tags;
    private CreateOpenZFSVolumeConfiguration openZFSConfiguration;

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateVolumeRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setVolumeType(String volumeType) {
        this.volumeType = volumeType;
    }

    public String getVolumeType() {
        return this.volumeType;
    }

    public CreateVolumeRequest withVolumeType(String volumeType) {
        this.setVolumeType(volumeType);
        return this;
    }

    public CreateVolumeRequest withVolumeType(VolumeType volumeType) {
        this.volumeType = volumeType.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateVolumeRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setOntapConfiguration(CreateOntapVolumeConfiguration ontapConfiguration) {
        this.ontapConfiguration = ontapConfiguration;
    }

    public CreateOntapVolumeConfiguration getOntapConfiguration() {
        return this.ontapConfiguration;
    }

    public CreateVolumeRequest withOntapConfiguration(CreateOntapVolumeConfiguration ontapConfiguration) {
        this.setOntapConfiguration(ontapConfiguration);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateVolumeRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateVolumeRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setOpenZFSConfiguration(CreateOpenZFSVolumeConfiguration openZFSConfiguration) {
        this.openZFSConfiguration = openZFSConfiguration;
    }

    public CreateOpenZFSVolumeConfiguration getOpenZFSConfiguration() {
        return this.openZFSConfiguration;
    }

    public CreateVolumeRequest withOpenZFSConfiguration(CreateOpenZFSVolumeConfiguration openZFSConfiguration) {
        this.setOpenZFSConfiguration(openZFSConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getVolumeType() != null) {
            sb.append("VolumeType: ").append(this.getVolumeType()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getOntapConfiguration() != null) {
            sb.append("OntapConfiguration: ").append(this.getOntapConfiguration()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getOpenZFSConfiguration() != null) {
            sb.append("OpenZFSConfiguration: ").append(this.getOpenZFSConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVolumeRequest)) {
            return false;
        }
        CreateVolumeRequest other = (CreateVolumeRequest)obj;
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getVolumeType() == null ^ this.getVolumeType() == null) {
            return false;
        }
        if (other.getVolumeType() != null && !other.getVolumeType().equals(this.getVolumeType())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getOntapConfiguration() == null ^ this.getOntapConfiguration() == null) {
            return false;
        }
        if (other.getOntapConfiguration() != null && !other.getOntapConfiguration().equals(this.getOntapConfiguration())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getOpenZFSConfiguration() == null ^ this.getOpenZFSConfiguration() == null) {
            return false;
        }
        return other.getOpenZFSConfiguration() == null || other.getOpenZFSConfiguration().equals(this.getOpenZFSConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeType() == null ? 0 : this.getVolumeType().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getOntapConfiguration() == null ? 0 : this.getOntapConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getOpenZFSConfiguration() == null ? 0 : this.getOpenZFSConfiguration().hashCode());
        return hashCode;
    }

    public CreateVolumeRequest clone() {
        return (CreateVolumeRequest)super.clone();
    }
}

