/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.DataRepositoryTask;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class DataRepositoryTaskMarshaller {
    private static final MarshallingInfo<String> TASKID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TaskId").build();
    private static final MarshallingInfo<String> LIFECYCLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Lifecycle").build();
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> STARTTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StartTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<Date> ENDTIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EndTime").timestampFormat("unixTimestamp").build();
    private static final MarshallingInfo<String> RESOURCEARN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceARN").build();
    private static final MarshallingInfo<List> TAGS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Tags").build();
    private static final MarshallingInfo<String> FILESYSTEMID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FileSystemId").build();
    private static final MarshallingInfo<List> PATHS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Paths").build();
    private static final MarshallingInfo<StructuredPojo> FAILUREDETAILS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("FailureDetails").build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").build();
    private static final MarshallingInfo<StructuredPojo> REPORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Report").build();
    private static final DataRepositoryTaskMarshaller instance = new DataRepositoryTaskMarshaller();

    public static DataRepositoryTaskMarshaller getInstance() {
        return instance;
    }

    public void marshall(DataRepositoryTask dataRepositoryTask, ProtocolMarshaller protocolMarshaller) {
        if (dataRepositoryTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)dataRepositoryTask.getTaskId(), TASKID_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getLifecycle(), LIFECYCLE_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getStartTime(), STARTTIME_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getEndTime(), ENDTIME_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getResourceARN(), RESOURCEARN_BINDING);
            protocolMarshaller.marshall(dataRepositoryTask.getTags(), TAGS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getFileSystemId(), FILESYSTEMID_BINDING);
            protocolMarshaller.marshall(dataRepositoryTask.getPaths(), PATHS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getFailureDetails(), FAILUREDETAILS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getStatus(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)dataRepositoryTask.getReport(), REPORT_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

