/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fsx.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fsx.model.ActiveDirectoryBackupAttributes;
import com.amazonaws.services.fsx.model.BackupFailureDetails;
import com.amazonaws.services.fsx.model.BackupLifecycle;
import com.amazonaws.services.fsx.model.BackupType;
import com.amazonaws.services.fsx.model.FileSystem;
import com.amazonaws.services.fsx.model.Tag;
import com.amazonaws.services.fsx.model.transform.BackupMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Backup
implements Serializable,
Cloneable,
StructuredPojo {
    private String backupId;
    private String lifecycle;
    private BackupFailureDetails failureDetails;
    private String type;
    private Integer progressPercent;
    private Date creationTime;
    private String kmsKeyId;
    private String resourceARN;
    private List<Tag> tags;
    private FileSystem fileSystem;
    private ActiveDirectoryBackupAttributes directoryInformation;
    private String ownerId;
    private String sourceBackupId;
    private String sourceBackupRegion;

    public void setBackupId(String backupId) {
        this.backupId = backupId;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public Backup withBackupId(String backupId) {
        this.setBackupId(backupId);
        return this;
    }

    public void setLifecycle(String lifecycle) {
        this.lifecycle = lifecycle;
    }

    public String getLifecycle() {
        return this.lifecycle;
    }

    public Backup withLifecycle(String lifecycle) {
        this.setLifecycle(lifecycle);
        return this;
    }

    public Backup withLifecycle(BackupLifecycle lifecycle) {
        this.lifecycle = lifecycle.toString();
        return this;
    }

    public void setFailureDetails(BackupFailureDetails failureDetails) {
        this.failureDetails = failureDetails;
    }

    public BackupFailureDetails getFailureDetails() {
        return this.failureDetails;
    }

    public Backup withFailureDetails(BackupFailureDetails failureDetails) {
        this.setFailureDetails(failureDetails);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Backup withType(String type) {
        this.setType(type);
        return this;
    }

    public Backup withType(BackupType type) {
        this.type = type.toString();
        return this;
    }

    public void setProgressPercent(Integer progressPercent) {
        this.progressPercent = progressPercent;
    }

    public Integer getProgressPercent() {
        return this.progressPercent;
    }

    public Backup withProgressPercent(Integer progressPercent) {
        this.setProgressPercent(progressPercent);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public Backup withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setKmsKeyId(String kmsKeyId) {
        this.kmsKeyId = kmsKeyId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Backup withKmsKeyId(String kmsKeyId) {
        this.setKmsKeyId(kmsKeyId);
        return this;
    }

    public void setResourceARN(String resourceARN) {
        this.resourceARN = resourceARN;
    }

    public String getResourceARN() {
        return this.resourceARN;
    }

    public Backup withResourceARN(String resourceARN) {
        this.setResourceARN(resourceARN);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public Backup withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public Backup withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setFileSystem(FileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    public Backup withFileSystem(FileSystem fileSystem) {
        this.setFileSystem(fileSystem);
        return this;
    }

    public void setDirectoryInformation(ActiveDirectoryBackupAttributes directoryInformation) {
        this.directoryInformation = directoryInformation;
    }

    public ActiveDirectoryBackupAttributes getDirectoryInformation() {
        return this.directoryInformation;
    }

    public Backup withDirectoryInformation(ActiveDirectoryBackupAttributes directoryInformation) {
        this.setDirectoryInformation(directoryInformation);
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Backup withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setSourceBackupId(String sourceBackupId) {
        this.sourceBackupId = sourceBackupId;
    }

    public String getSourceBackupId() {
        return this.sourceBackupId;
    }

    public Backup withSourceBackupId(String sourceBackupId) {
        this.setSourceBackupId(sourceBackupId);
        return this;
    }

    public void setSourceBackupRegion(String sourceBackupRegion) {
        this.sourceBackupRegion = sourceBackupRegion;
    }

    public String getSourceBackupRegion() {
        return this.sourceBackupRegion;
    }

    public Backup withSourceBackupRegion(String sourceBackupRegion) {
        this.setSourceBackupRegion(sourceBackupRegion);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getBackupId() != null) {
            sb.append("BackupId: ").append(this.getBackupId()).append(",");
        }
        if (this.getLifecycle() != null) {
            sb.append("Lifecycle: ").append(this.getLifecycle()).append(",");
        }
        if (this.getFailureDetails() != null) {
            sb.append("FailureDetails: ").append(this.getFailureDetails()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getProgressPercent() != null) {
            sb.append("ProgressPercent: ").append(this.getProgressPercent()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getKmsKeyId() != null) {
            sb.append("KmsKeyId: ").append(this.getKmsKeyId()).append(",");
        }
        if (this.getResourceARN() != null) {
            sb.append("ResourceARN: ").append(this.getResourceARN()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getFileSystem() != null) {
            sb.append("FileSystem: ").append(this.getFileSystem()).append(",");
        }
        if (this.getDirectoryInformation() != null) {
            sb.append("DirectoryInformation: ").append(this.getDirectoryInformation()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getSourceBackupId() != null) {
            sb.append("SourceBackupId: ").append(this.getSourceBackupId()).append(",");
        }
        if (this.getSourceBackupRegion() != null) {
            sb.append("SourceBackupRegion: ").append(this.getSourceBackupRegion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Backup)) {
            return false;
        }
        Backup other = (Backup)obj;
        if (other.getBackupId() == null ^ this.getBackupId() == null) {
            return false;
        }
        if (other.getBackupId() != null && !other.getBackupId().equals(this.getBackupId())) {
            return false;
        }
        if (other.getLifecycle() == null ^ this.getLifecycle() == null) {
            return false;
        }
        if (other.getLifecycle() != null && !other.getLifecycle().equals(this.getLifecycle())) {
            return false;
        }
        if (other.getFailureDetails() == null ^ this.getFailureDetails() == null) {
            return false;
        }
        if (other.getFailureDetails() != null && !other.getFailureDetails().equals(this.getFailureDetails())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getProgressPercent() == null ^ this.getProgressPercent() == null) {
            return false;
        }
        if (other.getProgressPercent() != null && !other.getProgressPercent().equals(this.getProgressPercent())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getKmsKeyId() == null ^ this.getKmsKeyId() == null) {
            return false;
        }
        if (other.getKmsKeyId() != null && !other.getKmsKeyId().equals(this.getKmsKeyId())) {
            return false;
        }
        if (other.getResourceARN() == null ^ this.getResourceARN() == null) {
            return false;
        }
        if (other.getResourceARN() != null && !other.getResourceARN().equals(this.getResourceARN())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getFileSystem() == null ^ this.getFileSystem() == null) {
            return false;
        }
        if (other.getFileSystem() != null && !other.getFileSystem().equals(this.getFileSystem())) {
            return false;
        }
        if (other.getDirectoryInformation() == null ^ this.getDirectoryInformation() == null) {
            return false;
        }
        if (other.getDirectoryInformation() != null && !other.getDirectoryInformation().equals(this.getDirectoryInformation())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getSourceBackupId() == null ^ this.getSourceBackupId() == null) {
            return false;
        }
        if (other.getSourceBackupId() != null && !other.getSourceBackupId().equals(this.getSourceBackupId())) {
            return false;
        }
        if (other.getSourceBackupRegion() == null ^ this.getSourceBackupRegion() == null) {
            return false;
        }
        return other.getSourceBackupRegion() == null || other.getSourceBackupRegion().equals(this.getSourceBackupRegion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getBackupId() == null ? 0 : this.getBackupId().hashCode());
        hashCode = 31 * hashCode + (this.getLifecycle() == null ? 0 : this.getLifecycle().hashCode());
        hashCode = 31 * hashCode + (this.getFailureDetails() == null ? 0 : this.getFailureDetails().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getProgressPercent() == null ? 0 : this.getProgressPercent().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getKmsKeyId() == null ? 0 : this.getKmsKeyId().hashCode());
        hashCode = 31 * hashCode + (this.getResourceARN() == null ? 0 : this.getResourceARN().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getFileSystem() == null ? 0 : this.getFileSystem().hashCode());
        hashCode = 31 * hashCode + (this.getDirectoryInformation() == null ? 0 : this.getDirectoryInformation().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getSourceBackupId() == null ? 0 : this.getSourceBackupId().hashCode());
        hashCode = 31 * hashCode + (this.getSourceBackupRegion() == null ? 0 : this.getSourceBackupRegion().hashCode());
        return hashCode;
    }

    public Backup clone() {
        try {
            return (Backup)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BackupMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

