/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.fis.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.fis.model.ActionTarget;
import com.amazonaws.services.fis.model.transform.ActionSummaryMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class ActionSummary
implements Serializable,
Cloneable,
StructuredPojo {
    private String id;
    private String description;
    private Map<String, ActionTarget> targets;
    private Map<String, String> tags;

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public ActionSummary withId(String id) {
        this.setId(id);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ActionSummary withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public Map<String, ActionTarget> getTargets() {
        return this.targets;
    }

    public void setTargets(Map<String, ActionTarget> targets) {
        this.targets = targets;
    }

    public ActionSummary withTargets(Map<String, ActionTarget> targets) {
        this.setTargets(targets);
        return this;
    }

    public ActionSummary addTargetsEntry(String key, ActionTarget value) {
        if (null == this.targets) {
            this.targets = new HashMap<String, ActionTarget>();
        }
        if (this.targets.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.targets.put(key, value);
        return this;
    }

    public ActionSummary clearTargetsEntries() {
        this.targets = null;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public ActionSummary withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public ActionSummary addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public ActionSummary clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getId() != null) {
            sb.append("Id: ").append(this.getId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getTargets() != null) {
            sb.append("Targets: ").append(this.getTargets()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ActionSummary)) {
            return false;
        }
        ActionSummary other = (ActionSummary)obj;
        if (other.getId() == null ^ this.getId() == null) {
            return false;
        }
        if (other.getId() != null && !other.getId().equals(this.getId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getTargets() == null ^ this.getTargets() == null) {
            return false;
        }
        if (other.getTargets() != null && !other.getTargets().equals(this.getTargets())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getId() == null ? 0 : this.getId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getTargets() == null ? 0 : this.getTargets().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public ActionSummary clone() {
        try {
            return (ActionSummary)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ActionSummaryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

