/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.eventbridge.model.ConnectionHttpParameters;
import com.amazonaws.services.eventbridge.model.ConnectionOAuthClientResponseParameters;
import com.amazonaws.services.eventbridge.model.ConnectionOAuthHttpMethod;
import com.amazonaws.services.eventbridge.model.transform.ConnectionOAuthResponseParametersMarshaller;
import java.io.Serializable;

public class ConnectionOAuthResponseParameters
implements Serializable,
Cloneable,
StructuredPojo {
    private ConnectionOAuthClientResponseParameters clientParameters;
    private String authorizationEndpoint;
    private String httpMethod;
    private ConnectionHttpParameters oAuthHttpParameters;

    public void setClientParameters(ConnectionOAuthClientResponseParameters clientParameters) {
        this.clientParameters = clientParameters;
    }

    public ConnectionOAuthClientResponseParameters getClientParameters() {
        return this.clientParameters;
    }

    public ConnectionOAuthResponseParameters withClientParameters(ConnectionOAuthClientResponseParameters clientParameters) {
        this.setClientParameters(clientParameters);
        return this;
    }

    public void setAuthorizationEndpoint(String authorizationEndpoint) {
        this.authorizationEndpoint = authorizationEndpoint;
    }

    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    public ConnectionOAuthResponseParameters withAuthorizationEndpoint(String authorizationEndpoint) {
        this.setAuthorizationEndpoint(authorizationEndpoint);
        return this;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public ConnectionOAuthResponseParameters withHttpMethod(String httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    public ConnectionOAuthResponseParameters withHttpMethod(ConnectionOAuthHttpMethod httpMethod) {
        this.httpMethod = httpMethod.toString();
        return this;
    }

    public void setOAuthHttpParameters(ConnectionHttpParameters oAuthHttpParameters) {
        this.oAuthHttpParameters = oAuthHttpParameters;
    }

    public ConnectionHttpParameters getOAuthHttpParameters() {
        return this.oAuthHttpParameters;
    }

    public ConnectionOAuthResponseParameters withOAuthHttpParameters(ConnectionHttpParameters oAuthHttpParameters) {
        this.setOAuthHttpParameters(oAuthHttpParameters);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientParameters() != null) {
            sb.append("ClientParameters: ").append(this.getClientParameters()).append(",");
        }
        if (this.getAuthorizationEndpoint() != null) {
            sb.append("AuthorizationEndpoint: ").append(this.getAuthorizationEndpoint()).append(",");
        }
        if (this.getHttpMethod() != null) {
            sb.append("HttpMethod: ").append(this.getHttpMethod()).append(",");
        }
        if (this.getOAuthHttpParameters() != null) {
            sb.append("OAuthHttpParameters: ").append(this.getOAuthHttpParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConnectionOAuthResponseParameters)) {
            return false;
        }
        ConnectionOAuthResponseParameters other = (ConnectionOAuthResponseParameters)obj;
        if (other.getClientParameters() == null ^ this.getClientParameters() == null) {
            return false;
        }
        if (other.getClientParameters() != null && !other.getClientParameters().equals(this.getClientParameters())) {
            return false;
        }
        if (other.getAuthorizationEndpoint() == null ^ this.getAuthorizationEndpoint() == null) {
            return false;
        }
        if (other.getAuthorizationEndpoint() != null && !other.getAuthorizationEndpoint().equals(this.getAuthorizationEndpoint())) {
            return false;
        }
        if (other.getHttpMethod() == null ^ this.getHttpMethod() == null) {
            return false;
        }
        if (other.getHttpMethod() != null && !other.getHttpMethod().equals(this.getHttpMethod())) {
            return false;
        }
        if (other.getOAuthHttpParameters() == null ^ this.getOAuthHttpParameters() == null) {
            return false;
        }
        return other.getOAuthHttpParameters() == null || other.getOAuthHttpParameters().equals(this.getOAuthHttpParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientParameters() == null ? 0 : this.getClientParameters().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizationEndpoint() == null ? 0 : this.getAuthorizationEndpoint().hashCode());
        hashCode = 31 * hashCode + (this.getHttpMethod() == null ? 0 : this.getHttpMethod().hashCode());
        hashCode = 31 * hashCode + (this.getOAuthHttpParameters() == null ? 0 : this.getOAuthHttpParameters().hashCode());
        return hashCode;
    }

    public ConnectionOAuthResponseParameters clone() {
        try {
            return (ConnectionOAuthResponseParameters)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ConnectionOAuthResponseParametersMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

