/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eventbridge;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.client.builder.AdvancedConfig;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.eventbridge.AmazonEventBridge;
import com.amazonaws.services.eventbridge.AmazonEventBridgeClientBuilder;
import com.amazonaws.services.eventbridge.model.ActivateEventSourceRequest;
import com.amazonaws.services.eventbridge.model.ActivateEventSourceResult;
import com.amazonaws.services.eventbridge.model.AmazonEventBridgeException;
import com.amazonaws.services.eventbridge.model.CancelReplayRequest;
import com.amazonaws.services.eventbridge.model.CancelReplayResult;
import com.amazonaws.services.eventbridge.model.CreateArchiveRequest;
import com.amazonaws.services.eventbridge.model.CreateArchiveResult;
import com.amazonaws.services.eventbridge.model.CreateEventBusRequest;
import com.amazonaws.services.eventbridge.model.CreateEventBusResult;
import com.amazonaws.services.eventbridge.model.CreatePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.CreatePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeactivateEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DeactivateEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeleteArchiveRequest;
import com.amazonaws.services.eventbridge.model.DeleteArchiveResult;
import com.amazonaws.services.eventbridge.model.DeleteEventBusRequest;
import com.amazonaws.services.eventbridge.model.DeleteEventBusResult;
import com.amazonaws.services.eventbridge.model.DeletePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DeletePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DeleteRuleRequest;
import com.amazonaws.services.eventbridge.model.DeleteRuleResult;
import com.amazonaws.services.eventbridge.model.DescribeArchiveRequest;
import com.amazonaws.services.eventbridge.model.DescribeArchiveResult;
import com.amazonaws.services.eventbridge.model.DescribeEventBusRequest;
import com.amazonaws.services.eventbridge.model.DescribeEventBusResult;
import com.amazonaws.services.eventbridge.model.DescribeEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DescribeEventSourceResult;
import com.amazonaws.services.eventbridge.model.DescribePartnerEventSourceRequest;
import com.amazonaws.services.eventbridge.model.DescribePartnerEventSourceResult;
import com.amazonaws.services.eventbridge.model.DescribeReplayRequest;
import com.amazonaws.services.eventbridge.model.DescribeReplayResult;
import com.amazonaws.services.eventbridge.model.DescribeRuleRequest;
import com.amazonaws.services.eventbridge.model.DescribeRuleResult;
import com.amazonaws.services.eventbridge.model.DisableRuleRequest;
import com.amazonaws.services.eventbridge.model.DisableRuleResult;
import com.amazonaws.services.eventbridge.model.EnableRuleRequest;
import com.amazonaws.services.eventbridge.model.EnableRuleResult;
import com.amazonaws.services.eventbridge.model.ListArchivesRequest;
import com.amazonaws.services.eventbridge.model.ListArchivesResult;
import com.amazonaws.services.eventbridge.model.ListEventBusesRequest;
import com.amazonaws.services.eventbridge.model.ListEventBusesResult;
import com.amazonaws.services.eventbridge.model.ListEventSourcesRequest;
import com.amazonaws.services.eventbridge.model.ListEventSourcesResult;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourceAccountsRequest;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourceAccountsResult;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourcesRequest;
import com.amazonaws.services.eventbridge.model.ListPartnerEventSourcesResult;
import com.amazonaws.services.eventbridge.model.ListReplaysRequest;
import com.amazonaws.services.eventbridge.model.ListReplaysResult;
import com.amazonaws.services.eventbridge.model.ListRuleNamesByTargetRequest;
import com.amazonaws.services.eventbridge.model.ListRuleNamesByTargetResult;
import com.amazonaws.services.eventbridge.model.ListRulesRequest;
import com.amazonaws.services.eventbridge.model.ListRulesResult;
import com.amazonaws.services.eventbridge.model.ListTagsForResourceRequest;
import com.amazonaws.services.eventbridge.model.ListTagsForResourceResult;
import com.amazonaws.services.eventbridge.model.ListTargetsByRuleRequest;
import com.amazonaws.services.eventbridge.model.ListTargetsByRuleResult;
import com.amazonaws.services.eventbridge.model.PutEventsRequest;
import com.amazonaws.services.eventbridge.model.PutEventsResult;
import com.amazonaws.services.eventbridge.model.PutPartnerEventsRequest;
import com.amazonaws.services.eventbridge.model.PutPartnerEventsResult;
import com.amazonaws.services.eventbridge.model.PutPermissionRequest;
import com.amazonaws.services.eventbridge.model.PutPermissionResult;
import com.amazonaws.services.eventbridge.model.PutRuleRequest;
import com.amazonaws.services.eventbridge.model.PutRuleResult;
import com.amazonaws.services.eventbridge.model.PutTargetsRequest;
import com.amazonaws.services.eventbridge.model.PutTargetsResult;
import com.amazonaws.services.eventbridge.model.RemovePermissionRequest;
import com.amazonaws.services.eventbridge.model.RemovePermissionResult;
import com.amazonaws.services.eventbridge.model.RemoveTargetsRequest;
import com.amazonaws.services.eventbridge.model.RemoveTargetsResult;
import com.amazonaws.services.eventbridge.model.StartReplayRequest;
import com.amazonaws.services.eventbridge.model.StartReplayResult;
import com.amazonaws.services.eventbridge.model.TagResourceRequest;
import com.amazonaws.services.eventbridge.model.TagResourceResult;
import com.amazonaws.services.eventbridge.model.TestEventPatternRequest;
import com.amazonaws.services.eventbridge.model.TestEventPatternResult;
import com.amazonaws.services.eventbridge.model.UntagResourceRequest;
import com.amazonaws.services.eventbridge.model.UntagResourceResult;
import com.amazonaws.services.eventbridge.model.UpdateArchiveRequest;
import com.amazonaws.services.eventbridge.model.UpdateArchiveResult;
import com.amazonaws.services.eventbridge.model.transform.ActivateEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ActivateEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.CancelReplayRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.CancelReplayResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ConcurrentModificationExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreateArchiveRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreateArchiveResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreateEventBusRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreateEventBusResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreatePartnerEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.CreatePartnerEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeactivateEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeactivateEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteArchiveRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteArchiveResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteEventBusRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteEventBusResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeletePartnerEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeletePartnerEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DeleteRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeArchiveRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeArchiveResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeEventBusRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeEventBusResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribePartnerEventSourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribePartnerEventSourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeReplayRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeReplayResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DescribeRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.DisableRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.DisableRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.EnableRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.EnableRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.IllegalStatusExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.InternalExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.InvalidEventPatternExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.InvalidStateExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.LimitExceededExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListArchivesRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListArchivesResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListEventBusesRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListEventBusesResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListEventSourcesRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListEventSourcesResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListPartnerEventSourceAccountsRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListPartnerEventSourceAccountsResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListPartnerEventSourcesRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListPartnerEventSourcesResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListReplaysRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListReplaysResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListRuleNamesByTargetRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListRuleNamesByTargetResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListRulesRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListRulesResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListTagsForResourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListTagsForResourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListTargetsByRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.ListTargetsByRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ManagedRuleExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.OperationDisabledExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PolicyLengthExceededExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutEventsRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutEventsResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutPartnerEventsRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutPartnerEventsResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutPermissionRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutPermissionResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutRuleRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutRuleResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutTargetsRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.PutTargetsResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.RemovePermissionRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.RemovePermissionResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.RemoveTargetsRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.RemoveTargetsResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ResourceAlreadyExistsExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.ResourceNotFoundExceptionUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.StartReplayRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.StartReplayResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.TagResourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.TagResourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.TestEventPatternRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.TestEventPatternResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.UntagResourceRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.UntagResourceResultJsonUnmarshaller;
import com.amazonaws.services.eventbridge.model.transform.UpdateArchiveRequestProtocolMarshaller;
import com.amazonaws.services.eventbridge.model.transform.UpdateArchiveResultJsonUnmarshaller;
import com.amazonaws.transform.JsonErrorUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonEventBridgeClient
extends AmazonWebServiceClient
implements AmazonEventBridge {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonEventBridge.class);
    private static final String DEFAULT_SIGNING_NAME = "events";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final AdvancedConfig advancedConfig;
    private static final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).withSupportsIon(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ConcurrentModificationException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ConcurrentModificationExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("PolicyLengthExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)PolicyLengthExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidStateException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidStateExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidEventPatternException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InvalidEventPatternExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withExceptionUnmarshaller((JsonErrorUnmarshaller)LimitExceededExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("OperationDisabledException").withExceptionUnmarshaller((JsonErrorUnmarshaller)OperationDisabledExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("IllegalStatusException").withExceptionUnmarshaller((JsonErrorUnmarshaller)IllegalStatusExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceNotFoundException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceNotFoundExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ResourceAlreadyExistsException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ResourceAlreadyExistsExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InternalException").withExceptionUnmarshaller((JsonErrorUnmarshaller)InternalExceptionUnmarshaller.getInstance())).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ManagedRuleException").withExceptionUnmarshaller((JsonErrorUnmarshaller)ManagedRuleExceptionUnmarshaller.getInstance())).withBaseServiceExceptionClass(AmazonEventBridgeException.class));

    public static AmazonEventBridgeClientBuilder builder() {
        return AmazonEventBridgeClientBuilder.standard();
    }

    AmazonEventBridgeClient(AwsSyncClientParams clientParams) {
        this(clientParams, false);
    }

    AmazonEventBridgeClient(AwsSyncClientParams clientParams, boolean endpointDiscoveryEnabled) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.advancedConfig = clientParams.getAdvancedConfig();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("events.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/eventbridge/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/eventbridge/request.handler2s"));
        this.requestHandler2s.addAll(chainFactory.getGlobalHandlers());
    }

    @Override
    public ActivateEventSourceResult activateEventSource(ActivateEventSourceRequest request) {
        request = (ActivateEventSourceRequest)this.beforeClientExecution(request);
        return this.executeActivateEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ActivateEventSourceResult executeActivateEventSource(ActivateEventSourceRequest activateEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(activateEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ActivateEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ActivateEventSourceRequestProtocolMarshaller(protocolFactory).marshall((ActivateEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)activateEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ActivateEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ActivateEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ActivateEventSourceResult activateEventSourceResult = (ActivateEventSourceResult)response.getAwsResponse();
            return activateEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CancelReplayResult cancelReplay(CancelReplayRequest request) {
        request = (CancelReplayRequest)this.beforeClientExecution(request);
        return this.executeCancelReplay(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CancelReplayResult executeCancelReplay(CancelReplayRequest cancelReplayRequest) {
        ExecutionContext executionContext = this.createExecutionContext(cancelReplayRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CancelReplayRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CancelReplayRequestProtocolMarshaller(protocolFactory).marshall((CancelReplayRequest)super.beforeMarshalling((AmazonWebServiceRequest)cancelReplayRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CancelReplay");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelReplayResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CancelReplayResult cancelReplayResult = (CancelReplayResult)response.getAwsResponse();
            return cancelReplayResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateArchiveResult createArchive(CreateArchiveRequest request) {
        request = (CreateArchiveRequest)this.beforeClientExecution(request);
        return this.executeCreateArchive(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateArchiveResult executeCreateArchive(CreateArchiveRequest createArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateArchiveRequestProtocolMarshaller(protocolFactory).marshall((CreateArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)createArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateArchive");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateArchiveResult createArchiveResult = (CreateArchiveResult)response.getAwsResponse();
            return createArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreateEventBusResult createEventBus(CreateEventBusRequest request) {
        request = (CreateEventBusRequest)this.beforeClientExecution(request);
        return this.executeCreateEventBus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreateEventBusResult executeCreateEventBus(CreateEventBusRequest createEventBusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createEventBusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateEventBusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateEventBusRequestProtocolMarshaller(protocolFactory).marshall((CreateEventBusRequest)super.beforeMarshalling((AmazonWebServiceRequest)createEventBusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreateEventBus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateEventBusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateEventBusResult createEventBusResult = (CreateEventBusResult)response.getAwsResponse();
            return createEventBusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public CreatePartnerEventSourceResult createPartnerEventSource(CreatePartnerEventSourceRequest request) {
        request = (CreatePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executeCreatePartnerEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final CreatePartnerEventSourceResult executeCreatePartnerEventSource(CreatePartnerEventSourceRequest createPartnerEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createPartnerEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreatePartnerEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreatePartnerEventSourceRequestProtocolMarshaller(protocolFactory).marshall((CreatePartnerEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)createPartnerEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"CreatePartnerEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreatePartnerEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreatePartnerEventSourceResult createPartnerEventSourceResult = (CreatePartnerEventSourceResult)response.getAwsResponse();
            return createPartnerEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeactivateEventSourceResult deactivateEventSource(DeactivateEventSourceRequest request) {
        request = (DeactivateEventSourceRequest)this.beforeClientExecution(request);
        return this.executeDeactivateEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeactivateEventSourceResult executeDeactivateEventSource(DeactivateEventSourceRequest deactivateEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deactivateEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeactivateEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeactivateEventSourceRequestProtocolMarshaller(protocolFactory).marshall((DeactivateEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deactivateEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeactivateEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeactivateEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeactivateEventSourceResult deactivateEventSourceResult = (DeactivateEventSourceResult)response.getAwsResponse();
            return deactivateEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteArchiveResult deleteArchive(DeleteArchiveRequest request) {
        request = (DeleteArchiveRequest)this.beforeClientExecution(request);
        return this.executeDeleteArchive(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteArchiveResult executeDeleteArchive(DeleteArchiveRequest deleteArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteArchiveRequestProtocolMarshaller(protocolFactory).marshall((DeleteArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteArchive");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteArchiveResult deleteArchiveResult = (DeleteArchiveResult)response.getAwsResponse();
            return deleteArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteEventBusResult deleteEventBus(DeleteEventBusRequest request) {
        request = (DeleteEventBusRequest)this.beforeClientExecution(request);
        return this.executeDeleteEventBus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteEventBusResult executeDeleteEventBus(DeleteEventBusRequest deleteEventBusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteEventBusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteEventBusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteEventBusRequestProtocolMarshaller(protocolFactory).marshall((DeleteEventBusRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteEventBusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteEventBus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteEventBusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteEventBusResult deleteEventBusResult = (DeleteEventBusResult)response.getAwsResponse();
            return deleteEventBusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeletePartnerEventSourceResult deletePartnerEventSource(DeletePartnerEventSourceRequest request) {
        request = (DeletePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executeDeletePartnerEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeletePartnerEventSourceResult executeDeletePartnerEventSource(DeletePartnerEventSourceRequest deletePartnerEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deletePartnerEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeletePartnerEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeletePartnerEventSourceRequestProtocolMarshaller(protocolFactory).marshall((DeletePartnerEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)deletePartnerEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeletePartnerEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeletePartnerEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeletePartnerEventSourceResult deletePartnerEventSourceResult = (DeletePartnerEventSourceResult)response.getAwsResponse();
            return deletePartnerEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DeleteRuleResult deleteRule(DeleteRuleRequest request) {
        request = (DeleteRuleRequest)this.beforeClientExecution(request);
        return this.executeDeleteRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DeleteRuleResult executeDeleteRule(DeleteRuleRequest deleteRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRuleRequestProtocolMarshaller(protocolFactory).marshall((DeleteRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DeleteRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRuleResult deleteRuleResult = (DeleteRuleResult)response.getAwsResponse();
            return deleteRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeArchiveResult describeArchive(DescribeArchiveRequest request) {
        request = (DescribeArchiveRequest)this.beforeClientExecution(request);
        return this.executeDescribeArchive(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeArchiveResult executeDescribeArchive(DescribeArchiveRequest describeArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeArchiveRequestProtocolMarshaller(protocolFactory).marshall((DescribeArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeArchive");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeArchiveResult describeArchiveResult = (DescribeArchiveResult)response.getAwsResponse();
            return describeArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventBusResult describeEventBus(DescribeEventBusRequest request) {
        request = (DescribeEventBusRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventBus(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventBusResult executeDescribeEventBus(DescribeEventBusRequest describeEventBusRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventBusRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventBusRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventBusRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventBusRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventBusRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventBus");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventBusResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventBusResult describeEventBusResult = (DescribeEventBusResult)response.getAwsResponse();
            return describeEventBusResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeEventSourceResult describeEventSource(DescribeEventSourceRequest request) {
        request = (DescribeEventSourceRequest)this.beforeClientExecution(request);
        return this.executeDescribeEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeEventSourceResult executeDescribeEventSource(DescribeEventSourceRequest describeEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeEventSourceRequestProtocolMarshaller(protocolFactory).marshall((DescribeEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeEventSourceResult describeEventSourceResult = (DescribeEventSourceResult)response.getAwsResponse();
            return describeEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribePartnerEventSourceResult describePartnerEventSource(DescribePartnerEventSourceRequest request) {
        request = (DescribePartnerEventSourceRequest)this.beforeClientExecution(request);
        return this.executeDescribePartnerEventSource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribePartnerEventSourceResult executeDescribePartnerEventSource(DescribePartnerEventSourceRequest describePartnerEventSourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describePartnerEventSourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribePartnerEventSourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribePartnerEventSourceRequestProtocolMarshaller(protocolFactory).marshall((DescribePartnerEventSourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)describePartnerEventSourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribePartnerEventSource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribePartnerEventSourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribePartnerEventSourceResult describePartnerEventSourceResult = (DescribePartnerEventSourceResult)response.getAwsResponse();
            return describePartnerEventSourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeReplayResult describeReplay(DescribeReplayRequest request) {
        request = (DescribeReplayRequest)this.beforeClientExecution(request);
        return this.executeDescribeReplay(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeReplayResult executeDescribeReplay(DescribeReplayRequest describeReplayRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeReplayRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeReplayRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeReplayRequestProtocolMarshaller(protocolFactory).marshall((DescribeReplayRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeReplayRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeReplay");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeReplayResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeReplayResult describeReplayResult = (DescribeReplayResult)response.getAwsResponse();
            return describeReplayResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DescribeRuleResult describeRule(DescribeRuleRequest request) {
        request = (DescribeRuleRequest)this.beforeClientExecution(request);
        return this.executeDescribeRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DescribeRuleResult executeDescribeRule(DescribeRuleRequest describeRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRuleRequestProtocolMarshaller(protocolFactory).marshall((DescribeRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DescribeRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRuleResult describeRuleResult = (DescribeRuleResult)response.getAwsResponse();
            return describeRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public DisableRuleResult disableRule(DisableRuleRequest request) {
        request = (DisableRuleRequest)this.beforeClientExecution(request);
        return this.executeDisableRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final DisableRuleResult executeDisableRule(DisableRuleRequest disableRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(disableRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DisableRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DisableRuleRequestProtocolMarshaller(protocolFactory).marshall((DisableRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)disableRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"DisableRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DisableRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DisableRuleResult disableRuleResult = (DisableRuleResult)response.getAwsResponse();
            return disableRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public EnableRuleResult enableRule(EnableRuleRequest request) {
        request = (EnableRuleRequest)this.beforeClientExecution(request);
        return this.executeEnableRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final EnableRuleResult executeEnableRule(EnableRuleRequest enableRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(enableRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<EnableRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new EnableRuleRequestProtocolMarshaller(protocolFactory).marshall((EnableRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)enableRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"EnableRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new EnableRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            EnableRuleResult enableRuleResult = (EnableRuleResult)response.getAwsResponse();
            return enableRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListArchivesResult listArchives(ListArchivesRequest request) {
        request = (ListArchivesRequest)this.beforeClientExecution(request);
        return this.executeListArchives(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListArchivesResult executeListArchives(ListArchivesRequest listArchivesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listArchivesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListArchivesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListArchivesRequestProtocolMarshaller(protocolFactory).marshall((ListArchivesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listArchivesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListArchives");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListArchivesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListArchivesResult listArchivesResult = (ListArchivesResult)response.getAwsResponse();
            return listArchivesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventBusesResult listEventBuses(ListEventBusesRequest request) {
        request = (ListEventBusesRequest)this.beforeClientExecution(request);
        return this.executeListEventBuses(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventBusesResult executeListEventBuses(ListEventBusesRequest listEventBusesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventBusesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventBusesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventBusesRequestProtocolMarshaller(protocolFactory).marshall((ListEventBusesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventBusesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEventBuses");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventBusesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventBusesResult listEventBusesResult = (ListEventBusesResult)response.getAwsResponse();
            return listEventBusesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListEventSourcesResult listEventSources(ListEventSourcesRequest request) {
        request = (ListEventSourcesRequest)this.beforeClientExecution(request);
        return this.executeListEventSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListEventSourcesResult executeListEventSources(ListEventSourcesRequest listEventSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listEventSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListEventSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListEventSourcesRequestProtocolMarshaller(protocolFactory).marshall((ListEventSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listEventSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListEventSources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListEventSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListEventSourcesResult listEventSourcesResult = (ListEventSourcesResult)response.getAwsResponse();
            return listEventSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPartnerEventSourceAccountsResult listPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest request) {
        request = (ListPartnerEventSourceAccountsRequest)this.beforeClientExecution(request);
        return this.executeListPartnerEventSourceAccounts(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPartnerEventSourceAccountsResult executeListPartnerEventSourceAccounts(ListPartnerEventSourceAccountsRequest listPartnerEventSourceAccountsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPartnerEventSourceAccountsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartnerEventSourceAccountsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartnerEventSourceAccountsRequestProtocolMarshaller(protocolFactory).marshall((ListPartnerEventSourceAccountsRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPartnerEventSourceAccountsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPartnerEventSourceAccounts");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPartnerEventSourceAccountsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPartnerEventSourceAccountsResult listPartnerEventSourceAccountsResult = (ListPartnerEventSourceAccountsResult)response.getAwsResponse();
            return listPartnerEventSourceAccountsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListPartnerEventSourcesResult listPartnerEventSources(ListPartnerEventSourcesRequest request) {
        request = (ListPartnerEventSourcesRequest)this.beforeClientExecution(request);
        return this.executeListPartnerEventSources(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListPartnerEventSourcesResult executeListPartnerEventSources(ListPartnerEventSourcesRequest listPartnerEventSourcesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listPartnerEventSourcesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListPartnerEventSourcesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListPartnerEventSourcesRequestProtocolMarshaller(protocolFactory).marshall((ListPartnerEventSourcesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listPartnerEventSourcesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListPartnerEventSources");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListPartnerEventSourcesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListPartnerEventSourcesResult listPartnerEventSourcesResult = (ListPartnerEventSourcesResult)response.getAwsResponse();
            return listPartnerEventSourcesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListReplaysResult listReplays(ListReplaysRequest request) {
        request = (ListReplaysRequest)this.beforeClientExecution(request);
        return this.executeListReplays(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListReplaysResult executeListReplays(ListReplaysRequest listReplaysRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listReplaysRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListReplaysRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListReplaysRequestProtocolMarshaller(protocolFactory).marshall((ListReplaysRequest)super.beforeMarshalling((AmazonWebServiceRequest)listReplaysRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListReplays");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListReplaysResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListReplaysResult listReplaysResult = (ListReplaysResult)response.getAwsResponse();
            return listReplaysResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRuleNamesByTargetResult listRuleNamesByTarget(ListRuleNamesByTargetRequest request) {
        request = (ListRuleNamesByTargetRequest)this.beforeClientExecution(request);
        return this.executeListRuleNamesByTarget(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRuleNamesByTargetResult executeListRuleNamesByTarget(ListRuleNamesByTargetRequest listRuleNamesByTargetRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRuleNamesByTargetRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRuleNamesByTargetRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRuleNamesByTargetRequestProtocolMarshaller(protocolFactory).marshall((ListRuleNamesByTargetRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRuleNamesByTargetRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRuleNamesByTarget");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRuleNamesByTargetResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRuleNamesByTargetResult listRuleNamesByTargetResult = (ListRuleNamesByTargetResult)response.getAwsResponse();
            return listRuleNamesByTargetResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListRulesResult listRules(ListRulesRequest request) {
        request = (ListRulesRequest)this.beforeClientExecution(request);
        return this.executeListRules(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListRulesResult executeListRules(ListRulesRequest listRulesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listRulesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListRulesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListRulesRequestProtocolMarshaller(protocolFactory).marshall((ListRulesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listRulesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListRules");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListRulesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListRulesResult listRulesResult = (ListRulesResult)response.getAwsResponse();
            return listRulesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        request = (ListTagsForResourceRequest)this.beforeClientExecution(request);
        return this.executeListTagsForResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTagsForResourceResult executeListTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTagsForResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTagsForResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTagsForResourceRequestProtocolMarshaller(protocolFactory).marshall((ListTagsForResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTagsForResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTagsForResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTagsForResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTagsForResourceResult listTagsForResourceResult = (ListTagsForResourceResult)response.getAwsResponse();
            return listTagsForResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ListTargetsByRuleResult listTargetsByRule(ListTargetsByRuleRequest request) {
        request = (ListTargetsByRuleRequest)this.beforeClientExecution(request);
        return this.executeListTargetsByRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final ListTargetsByRuleResult executeListTargetsByRule(ListTargetsByRuleRequest listTargetsByRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listTargetsByRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListTargetsByRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListTargetsByRuleRequestProtocolMarshaller(protocolFactory).marshall((ListTargetsByRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)listTargetsByRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"ListTargetsByRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListTargetsByRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListTargetsByRuleResult listTargetsByRuleResult = (ListTargetsByRuleResult)response.getAwsResponse();
            return listTargetsByRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutEventsResult putEvents(PutEventsRequest request) {
        request = (PutEventsRequest)this.beforeClientExecution(request);
        return this.executePutEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutEventsResult executePutEvents(PutEventsRequest putEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutEventsRequestProtocolMarshaller(protocolFactory).marshall((PutEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutEventsResult putEventsResult = (PutEventsResult)response.getAwsResponse();
            return putEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPartnerEventsResult putPartnerEvents(PutPartnerEventsRequest request) {
        request = (PutPartnerEventsRequest)this.beforeClientExecution(request);
        return this.executePutPartnerEvents(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPartnerEventsResult executePutPartnerEvents(PutPartnerEventsRequest putPartnerEventsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPartnerEventsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPartnerEventsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPartnerEventsRequestProtocolMarshaller(protocolFactory).marshall((PutPartnerEventsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPartnerEventsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPartnerEvents");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPartnerEventsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPartnerEventsResult putPartnerEventsResult = (PutPartnerEventsResult)response.getAwsResponse();
            return putPartnerEventsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutPermissionResult putPermission(PutPermissionRequest request) {
        request = (PutPermissionRequest)this.beforeClientExecution(request);
        return this.executePutPermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutPermissionResult executePutPermission(PutPermissionRequest putPermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putPermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutPermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutPermissionRequestProtocolMarshaller(protocolFactory).marshall((PutPermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)putPermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutPermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutPermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutPermissionResult putPermissionResult = (PutPermissionResult)response.getAwsResponse();
            return putPermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutRuleResult putRule(PutRuleRequest request) {
        request = (PutRuleRequest)this.beforeClientExecution(request);
        return this.executePutRule(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutRuleResult executePutRule(PutRuleRequest putRuleRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putRuleRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutRuleRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutRuleRequestProtocolMarshaller(protocolFactory).marshall((PutRuleRequest)super.beforeMarshalling((AmazonWebServiceRequest)putRuleRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutRule");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutRuleResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutRuleResult putRuleResult = (PutRuleResult)response.getAwsResponse();
            return putRuleResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public PutTargetsResult putTargets(PutTargetsRequest request) {
        request = (PutTargetsRequest)this.beforeClientExecution(request);
        return this.executePutTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final PutTargetsResult executePutTargets(PutTargetsRequest putTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutTargetsRequestProtocolMarshaller(protocolFactory).marshall((PutTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)putTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"PutTargets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutTargetsResult putTargetsResult = (PutTargetsResult)response.getAwsResponse();
            return putTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemovePermissionResult removePermission(RemovePermissionRequest request) {
        request = (RemovePermissionRequest)this.beforeClientExecution(request);
        return this.executeRemovePermission(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemovePermissionResult executeRemovePermission(RemovePermissionRequest removePermissionRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removePermissionRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemovePermissionRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemovePermissionRequestProtocolMarshaller(protocolFactory).marshall((RemovePermissionRequest)super.beforeMarshalling((AmazonWebServiceRequest)removePermissionRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemovePermission");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemovePermissionResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemovePermissionResult removePermissionResult = (RemovePermissionResult)response.getAwsResponse();
            return removePermissionResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public RemoveTargetsResult removeTargets(RemoveTargetsRequest request) {
        request = (RemoveTargetsRequest)this.beforeClientExecution(request);
        return this.executeRemoveTargets(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final RemoveTargetsResult executeRemoveTargets(RemoveTargetsRequest removeTargetsRequest) {
        ExecutionContext executionContext = this.createExecutionContext(removeTargetsRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<RemoveTargetsRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new RemoveTargetsRequestProtocolMarshaller(protocolFactory).marshall((RemoveTargetsRequest)super.beforeMarshalling((AmazonWebServiceRequest)removeTargetsRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"RemoveTargets");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RemoveTargetsResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            RemoveTargetsResult removeTargetsResult = (RemoveTargetsResult)response.getAwsResponse();
            return removeTargetsResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public StartReplayResult startReplay(StartReplayRequest request) {
        request = (StartReplayRequest)this.beforeClientExecution(request);
        return this.executeStartReplay(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final StartReplayResult executeStartReplay(StartReplayRequest startReplayRequest) {
        ExecutionContext executionContext = this.createExecutionContext(startReplayRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<StartReplayRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new StartReplayRequestProtocolMarshaller(protocolFactory).marshall((StartReplayRequest)super.beforeMarshalling((AmazonWebServiceRequest)startReplayRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"StartReplay");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new StartReplayResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            StartReplayResult startReplayResult = (StartReplayResult)response.getAwsResponse();
            return startReplayResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        request = (TagResourceRequest)this.beforeClientExecution(request);
        return this.executeTagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TagResourceResult executeTagResource(TagResourceRequest tagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(tagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TagResourceRequestProtocolMarshaller(protocolFactory).marshall((TagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)tagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TagResourceResult tagResourceResult = (TagResourceResult)response.getAwsResponse();
            return tagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public TestEventPatternResult testEventPattern(TestEventPatternRequest request) {
        request = (TestEventPatternRequest)this.beforeClientExecution(request);
        return this.executeTestEventPattern(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final TestEventPatternResult executeTestEventPattern(TestEventPatternRequest testEventPatternRequest) {
        ExecutionContext executionContext = this.createExecutionContext(testEventPatternRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<TestEventPatternRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new TestEventPatternRequestProtocolMarshaller(protocolFactory).marshall((TestEventPatternRequest)super.beforeMarshalling((AmazonWebServiceRequest)testEventPatternRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"TestEventPattern");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TestEventPatternResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            TestEventPatternResult testEventPatternResult = (TestEventPatternResult)response.getAwsResponse();
            return testEventPatternResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        request = (UntagResourceRequest)this.beforeClientExecution(request);
        return this.executeUntagResource(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UntagResourceResult executeUntagResource(UntagResourceRequest untagResourceRequest) {
        ExecutionContext executionContext = this.createExecutionContext(untagResourceRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UntagResourceRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UntagResourceRequestProtocolMarshaller(protocolFactory).marshall((UntagResourceRequest)super.beforeMarshalling((AmazonWebServiceRequest)untagResourceRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UntagResource");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UntagResourceResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UntagResourceResult untagResourceResult = (UntagResourceResult)response.getAwsResponse();
            return untagResourceResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public UpdateArchiveResult updateArchive(UpdateArchiveRequest request) {
        request = (UpdateArchiveRequest)this.beforeClientExecution(request);
        return this.executeUpdateArchive(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SdkInternalApi
    final UpdateArchiveResult executeUpdateArchive(UpdateArchiveRequest updateArchiveRequest) {
        ExecutionContext executionContext = this.createExecutionContext(updateArchiveRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UpdateArchiveRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UpdateArchiveRequestProtocolMarshaller(protocolFactory).marshall((UpdateArchiveRequest)super.beforeMarshalling((AmazonWebServiceRequest)updateArchiveRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
                request.addHandlerContext(HandlerContextKey.CLIENT_ENDPOINT, (Object)this.endpoint);
                request.addHandlerContext(HandlerContextKey.ENDPOINT_OVERRIDDEN, (Object)this.isEndpointOverridden());
                request.addHandlerContext(HandlerContextKey.SIGNING_REGION, (Object)this.getSigningRegion());
                request.addHandlerContext(HandlerContextKey.SERVICE_ID, (Object)"EventBridge");
                request.addHandlerContext(HandlerContextKey.OPERATION_NAME, (Object)"UpdateArchive");
                request.addHandlerContext(HandlerContextKey.ADVANCED_CONFIG, (Object)this.advancedConfig);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateArchiveResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UpdateArchiveResult updateArchiveResult = (UpdateArchiveResult)response.getAwsResponse();
            return updateArchiveResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.invoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI cachedEndpoint, URI uriFromEndpointTrait) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext, cachedEndpoint, uriFromEndpointTrait);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext, null, null);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext, URI discoveredEndpoint, URI uriFromEndpointTrait) {
        if (discoveredEndpoint != null) {
            request.setEndpoint(discoveredEndpoint);
            request.getOriginalRequest().getRequestClientOptions().appendUserAgent("endpoint-discovery");
        } else if (uriFromEndpointTrait != null) {
            request.setEndpoint(uriFromEndpointTrait);
        } else {
            request.setEndpoint(this.endpoint);
        }
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }

    @SdkInternalApi
    static SdkJsonProtocolFactory getProtocolFactory() {
        return protocolFactory;
    }

    @Override
    public void shutdown() {
        super.shutdown();
    }
}

