/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.entityresolution.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.entityresolution.model.OutputAttribute;
import com.amazonaws.services.entityresolution.model.transform.OutputSourceMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OutputSource
implements Serializable,
Cloneable,
StructuredPojo {
    private String kMSArn;
    private Boolean applyNormalization;
    private List<OutputAttribute> output;
    private String outputS3Path;

    public void setKMSArn(String kMSArn) {
        this.kMSArn = kMSArn;
    }

    public String getKMSArn() {
        return this.kMSArn;
    }

    public OutputSource withKMSArn(String kMSArn) {
        this.setKMSArn(kMSArn);
        return this;
    }

    public void setApplyNormalization(Boolean applyNormalization) {
        this.applyNormalization = applyNormalization;
    }

    public Boolean getApplyNormalization() {
        return this.applyNormalization;
    }

    public OutputSource withApplyNormalization(Boolean applyNormalization) {
        this.setApplyNormalization(applyNormalization);
        return this;
    }

    public Boolean isApplyNormalization() {
        return this.applyNormalization;
    }

    public List<OutputAttribute> getOutput() {
        return this.output;
    }

    public void setOutput(Collection<OutputAttribute> output) {
        if (output == null) {
            this.output = null;
            return;
        }
        this.output = new ArrayList<OutputAttribute>(output);
    }

    public OutputSource withOutput(OutputAttribute ... output) {
        if (this.output == null) {
            this.setOutput(new ArrayList<OutputAttribute>(output.length));
        }
        for (OutputAttribute ele : output) {
            this.output.add(ele);
        }
        return this;
    }

    public OutputSource withOutput(Collection<OutputAttribute> output) {
        this.setOutput(output);
        return this;
    }

    public void setOutputS3Path(String outputS3Path) {
        this.outputS3Path = outputS3Path;
    }

    public String getOutputS3Path() {
        return this.outputS3Path;
    }

    public OutputSource withOutputS3Path(String outputS3Path) {
        this.setOutputS3Path(outputS3Path);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getKMSArn() != null) {
            sb.append("KMSArn: ").append(this.getKMSArn()).append(",");
        }
        if (this.getApplyNormalization() != null) {
            sb.append("ApplyNormalization: ").append(this.getApplyNormalization()).append(",");
        }
        if (this.getOutput() != null) {
            sb.append("Output: ").append(this.getOutput()).append(",");
        }
        if (this.getOutputS3Path() != null) {
            sb.append("OutputS3Path: ").append(this.getOutputS3Path());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OutputSource)) {
            return false;
        }
        OutputSource other = (OutputSource)obj;
        if (other.getKMSArn() == null ^ this.getKMSArn() == null) {
            return false;
        }
        if (other.getKMSArn() != null && !other.getKMSArn().equals(this.getKMSArn())) {
            return false;
        }
        if (other.getApplyNormalization() == null ^ this.getApplyNormalization() == null) {
            return false;
        }
        if (other.getApplyNormalization() != null && !other.getApplyNormalization().equals(this.getApplyNormalization())) {
            return false;
        }
        if (other.getOutput() == null ^ this.getOutput() == null) {
            return false;
        }
        if (other.getOutput() != null && !other.getOutput().equals(this.getOutput())) {
            return false;
        }
        if (other.getOutputS3Path() == null ^ this.getOutputS3Path() == null) {
            return false;
        }
        return other.getOutputS3Path() == null || other.getOutputS3Path().equals(this.getOutputS3Path());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getKMSArn() == null ? 0 : this.getKMSArn().hashCode());
        hashCode = 31 * hashCode + (this.getApplyNormalization() == null ? 0 : this.getApplyNormalization().hashCode());
        hashCode = 31 * hashCode + (this.getOutput() == null ? 0 : this.getOutput().hashCode());
        hashCode = 31 * hashCode + (this.getOutputS3Path() == null ? 0 : this.getOutputS3Path().hashCode());
        return hashCode;
    }

    public OutputSource clone() {
        try {
            return (OutputSource)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        OutputSourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

