/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.emrcontainers.model;

import java.io.Serializable;
import javax.annotation.Generated;

import com.amazonaws.AmazonWebServiceRequest;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/emr-containers-2020-10-01/CreateSecurityConfiguration"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class CreateSecurityConfigurationRequest extends com.amazonaws.AmazonWebServiceRequest implements Serializable, Cloneable {

    /**
     * <p>
     * The client idempotency token to use when creating the security configuration.
     * </p>
     */
    private String clientToken;
    /**
     * <p>
     * The name of the security configuration.
     * </p>
     */
    private String name;
    /**
     * <p>
     * Security configuration input for the request.
     * </p>
     */
    private SecurityConfigurationData securityConfigurationData;
    /**
     * <p>
     * The tags to add to the security configuration.
     * </p>
     */
    private java.util.Map<String, String> tags;

    /**
     * <p>
     * The client idempotency token to use when creating the security configuration.
     * </p>
     * 
     * @param clientToken
     *        The client idempotency token to use when creating the security configuration.
     */

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    /**
     * <p>
     * The client idempotency token to use when creating the security configuration.
     * </p>
     * 
     * @return The client idempotency token to use when creating the security configuration.
     */

    public String getClientToken() {
        return this.clientToken;
    }

    /**
     * <p>
     * The client idempotency token to use when creating the security configuration.
     * </p>
     * 
     * @param clientToken
     *        The client idempotency token to use when creating the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest withClientToken(String clientToken) {
        setClientToken(clientToken);
        return this;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @param name
     *        The name of the security configuration.
     */

    public void setName(String name) {
        this.name = name;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */

    public String getName() {
        return this.name;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @param name
     *        The name of the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest withName(String name) {
        setName(name);
        return this;
    }

    /**
     * <p>
     * Security configuration input for the request.
     * </p>
     * 
     * @param securityConfigurationData
     *        Security configuration input for the request.
     */

    public void setSecurityConfigurationData(SecurityConfigurationData securityConfigurationData) {
        this.securityConfigurationData = securityConfigurationData;
    }

    /**
     * <p>
     * Security configuration input for the request.
     * </p>
     * 
     * @return Security configuration input for the request.
     */

    public SecurityConfigurationData getSecurityConfigurationData() {
        return this.securityConfigurationData;
    }

    /**
     * <p>
     * Security configuration input for the request.
     * </p>
     * 
     * @param securityConfigurationData
     *        Security configuration input for the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest withSecurityConfigurationData(SecurityConfigurationData securityConfigurationData) {
        setSecurityConfigurationData(securityConfigurationData);
        return this;
    }

    /**
     * <p>
     * The tags to add to the security configuration.
     * </p>
     * 
     * @return The tags to add to the security configuration.
     */

    public java.util.Map<String, String> getTags() {
        return tags;
    }

    /**
     * <p>
     * The tags to add to the security configuration.
     * </p>
     * 
     * @param tags
     *        The tags to add to the security configuration.
     */

    public void setTags(java.util.Map<String, String> tags) {
        this.tags = tags;
    }

    /**
     * <p>
     * The tags to add to the security configuration.
     * </p>
     * 
     * @param tags
     *        The tags to add to the security configuration.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest withTags(java.util.Map<String, String> tags) {
        setTags(tags);
        return this;
    }

    /**
     * Add a single Tags entry
     *
     * @see CreateSecurityConfigurationRequest#withTags
     * @returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new java.util.HashMap<String, String>();
        }
        if (this.tags.containsKey(key))
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        this.tags.put(key, value);
        return this;
    }

    /**
     * Removes all the entries added into Tags.
     *
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public CreateSecurityConfigurationRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getClientToken() != null)
            sb.append("ClientToken: ").append(getClientToken()).append(",");
        if (getName() != null)
            sb.append("Name: ").append(getName()).append(",");
        if (getSecurityConfigurationData() != null)
            sb.append("SecurityConfigurationData: ").append(getSecurityConfigurationData()).append(",");
        if (getTags() != null)
            sb.append("Tags: ").append(getTags());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof CreateSecurityConfigurationRequest == false)
            return false;
        CreateSecurityConfigurationRequest other = (CreateSecurityConfigurationRequest) obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null)
            return false;
        if (other.getClientToken() != null && other.getClientToken().equals(this.getClientToken()) == false)
            return false;
        if (other.getName() == null ^ this.getName() == null)
            return false;
        if (other.getName() != null && other.getName().equals(this.getName()) == false)
            return false;
        if (other.getSecurityConfigurationData() == null ^ this.getSecurityConfigurationData() == null)
            return false;
        if (other.getSecurityConfigurationData() != null && other.getSecurityConfigurationData().equals(this.getSecurityConfigurationData()) == false)
            return false;
        if (other.getTags() == null ^ this.getTags() == null)
            return false;
        if (other.getTags() != null && other.getTags().equals(this.getTags()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getClientToken() == null) ? 0 : getClientToken().hashCode());
        hashCode = prime * hashCode + ((getName() == null) ? 0 : getName().hashCode());
        hashCode = prime * hashCode + ((getSecurityConfigurationData() == null) ? 0 : getSecurityConfigurationData().hashCode());
        hashCode = prime * hashCode + ((getTags() == null) ? 0 : getTags().hashCode());
        return hashCode;
    }

    @Override
    public CreateSecurityConfigurationRequest clone() {
        return (CreateSecurityConfigurationRequest) super.clone();
    }

}
