/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.elasticmapreduce.model.SupportedInstanceType;

@SdkInternalApi
public class SupportedInstanceTypeMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<Float> MEMORYGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MemoryGB").build();
    private static final MarshallingInfo<Integer> STORAGEGB_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageGB").build();
    private static final MarshallingInfo<Integer> VCPU_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("VCPU").build();
    private static final MarshallingInfo<Boolean> IS64BITSONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Is64BitsOnly").build();
    private static final MarshallingInfo<String> INSTANCEFAMILYID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("InstanceFamilyId").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZEDAVAILABLE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimizedAvailable").build();
    private static final MarshallingInfo<Boolean> EBSOPTIMIZEDBYDEFAULT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsOptimizedByDefault").build();
    private static final MarshallingInfo<Integer> NUMBEROFDISKS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("NumberOfDisks").build();
    private static final MarshallingInfo<Boolean> EBSSTORAGEONLY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("EbsStorageOnly").build();
    private static final MarshallingInfo<String> ARCHITECTURE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Architecture").build();
    private static final SupportedInstanceTypeMarshaller instance = new SupportedInstanceTypeMarshaller();

    public static SupportedInstanceTypeMarshaller getInstance() {
        return instance;
    }

    public void marshall(SupportedInstanceType supportedInstanceType, ProtocolMarshaller protocolMarshaller) {
        if (supportedInstanceType == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)supportedInstanceType.getType(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getMemoryGB(), MEMORYGB_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getStorageGB(), STORAGEGB_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getVCPU(), VCPU_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getIs64BitsOnly(), IS64BITSONLY_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getInstanceFamilyId(), INSTANCEFAMILYID_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getEbsOptimizedAvailable(), EBSOPTIMIZEDAVAILABLE_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getEbsOptimizedByDefault(), EBSOPTIMIZEDBYDEFAULT_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getNumberOfDisks(), NUMBEROFDISKS_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getEbsStorageOnly(), EBSSTORAGEONLY_BINDING);
            protocolMarshaller.marshall((Object)supportedInstanceType.getArchitecture(), ARCHITECTURE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

