/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticmapreduce.model.CreateSecurityConfigurationRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class CreateSecurityConfigurationRequestMarshaller
implements Marshaller<Request<CreateSecurityConfigurationRequest>, CreateSecurityConfigurationRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public CreateSecurityConfigurationRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateSecurityConfigurationRequest> marshall(CreateSecurityConfigurationRequest createSecurityConfigurationRequest) {
        if (createSecurityConfigurationRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createSecurityConfigurationRequest, "AmazonElasticMapReduce");
        request.addHeader("X-Amz-Target", "ElasticMapReduce.CreateSecurityConfiguration");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (createSecurityConfigurationRequest.getName() != null) {
                jsonGenerator.writeFieldName("Name").writeValue(createSecurityConfigurationRequest.getName());
            }
            if (createSecurityConfigurationRequest.getSecurityConfiguration() != null) {
                jsonGenerator.writeFieldName("SecurityConfiguration").writeValue(createSecurityConfigurationRequest.getSecurityConfiguration());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

