/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticmapreduce.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.internal.SdkInternalMap;
import com.amazonaws.services.elasticmapreduce.model.Configuration;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.Map;

public class ConfigurationJsonMarshaller {
    private static ConfigurationJsonMarshaller instance;

    public void marshall(Configuration configuration, SdkJsonGenerator jsonGenerator) {
        if (configuration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalMap propertiesMap;
            SdkInternalList configurationsList;
            jsonGenerator.writeStartObject();
            if (configuration.getClassification() != null) {
                jsonGenerator.writeFieldName("Classification").writeValue(configuration.getClassification());
            }
            if (!(configurationsList = (SdkInternalList)configuration.getConfigurations()).isEmpty() || !configurationsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Configurations");
                jsonGenerator.writeStartArray();
                for (Configuration configurationsListValue : configurationsList) {
                    if (configurationsListValue == null) continue;
                    ConfigurationJsonMarshaller.getInstance().marshall(configurationsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(propertiesMap = (SdkInternalMap)configuration.getProperties()).isEmpty() || !propertiesMap.isAutoConstruct()) {
                jsonGenerator.writeFieldName("Properties");
                jsonGenerator.writeStartObject();
                for (Map.Entry propertiesMapValue : propertiesMap.entrySet()) {
                    if (propertiesMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)propertiesMapValue.getKey());
                    jsonGenerator.writeValue((String)propertiesMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ConfigurationJsonMarshaller();
        }
        return instance;
    }
}

