/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import com.amazonaws.services.elastictranscoder.model.transform.NotificationsJsonMarshaller;
import com.amazonaws.services.elastictranscoder.model.transform.PipelineOutputConfigJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class PipelineJsonMarshaller {
    private static PipelineJsonMarshaller instance;

    public void marshall(Pipeline pipeline, JSONWriter jsonWriter) {
        if (pipeline == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (pipeline.getId() != null) {
                jsonWriter.key("Id").value((Object)pipeline.getId());
            }
            if (pipeline.getArn() != null) {
                jsonWriter.key("Arn").value((Object)pipeline.getArn());
            }
            if (pipeline.getName() != null) {
                jsonWriter.key("Name").value((Object)pipeline.getName());
            }
            if (pipeline.getStatus() != null) {
                jsonWriter.key("Status").value((Object)pipeline.getStatus());
            }
            if (pipeline.getInputBucket() != null) {
                jsonWriter.key("InputBucket").value((Object)pipeline.getInputBucket());
            }
            if (pipeline.getOutputBucket() != null) {
                jsonWriter.key("OutputBucket").value((Object)pipeline.getOutputBucket());
            }
            if (pipeline.getRole() != null) {
                jsonWriter.key("Role").value((Object)pipeline.getRole());
            }
            if (pipeline.getAwsKmsKeyArn() != null) {
                jsonWriter.key("AwsKmsKeyArn").value((Object)pipeline.getAwsKmsKeyArn());
            }
            if (pipeline.getNotifications() != null) {
                jsonWriter.key("Notifications");
                NotificationsJsonMarshaller.getInstance().marshall(pipeline.getNotifications(), jsonWriter);
            }
            if (pipeline.getContentConfig() != null) {
                jsonWriter.key("ContentConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getContentConfig(), jsonWriter);
            }
            if (pipeline.getThumbnailConfig() != null) {
                jsonWriter.key("ThumbnailConfig");
                PipelineOutputConfigJsonMarshaller.getInstance().marshall(pipeline.getThumbnailConfig(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PipelineJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PipelineJsonMarshaller();
        }
        return instance;
    }
}

