/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elastictranscoder.model.CaptionSource;
import com.amazonaws.services.elastictranscoder.model.transform.EncryptionJsonMarshaller;
import com.amazonaws.util.json.JSONWriter;

public class CaptionSourceJsonMarshaller {
    private static CaptionSourceJsonMarshaller instance;

    public void marshall(CaptionSource captionSource, JSONWriter jsonWriter) {
        if (captionSource == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (captionSource.getKey() != null) {
                jsonWriter.key("Key").value((Object)captionSource.getKey());
            }
            if (captionSource.getLanguage() != null) {
                jsonWriter.key("Language").value((Object)captionSource.getLanguage());
            }
            if (captionSource.getTimeOffset() != null) {
                jsonWriter.key("TimeOffset").value((Object)captionSource.getTimeOffset());
            }
            if (captionSource.getLabel() != null) {
                jsonWriter.key("Label").value((Object)captionSource.getLabel());
            }
            if (captionSource.getEncryption() != null) {
                jsonWriter.key("Encryption");
                EncryptionJsonMarshaller.getInstance().marshall(captionSource.getEncryption(), jsonWriter);
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static CaptionSourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new CaptionSourceJsonMarshaller();
        }
        return instance;
    }
}

