/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.elasticsearch.model.ElasticsearchDomainStatus;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.util.json.SdkJsonGenerator;
import java.util.Map;

public class ElasticsearchDomainStatusJsonMarshaller {
    private static ElasticsearchDomainStatusJsonMarshaller instance;

    public void marshall(ElasticsearchDomainStatus elasticsearchDomainStatus, SdkJsonGenerator jsonGenerator) {
        if (elasticsearchDomainStatus == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> advancedOptionsMap;
            jsonGenerator.writeStartObject();
            if (elasticsearchDomainStatus.getDomainId() != null) {
                jsonGenerator.writeFieldName("DomainId").writeValue(elasticsearchDomainStatus.getDomainId());
            }
            if (elasticsearchDomainStatus.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(elasticsearchDomainStatus.getDomainName());
            }
            if (elasticsearchDomainStatus.getARN() != null) {
                jsonGenerator.writeFieldName("ARN").writeValue(elasticsearchDomainStatus.getARN());
            }
            if (elasticsearchDomainStatus.getCreated() != null) {
                jsonGenerator.writeFieldName("Created").writeValue(elasticsearchDomainStatus.getCreated().booleanValue());
            }
            if (elasticsearchDomainStatus.getDeleted() != null) {
                jsonGenerator.writeFieldName("Deleted").writeValue(elasticsearchDomainStatus.getDeleted().booleanValue());
            }
            if (elasticsearchDomainStatus.getEndpoint() != null) {
                jsonGenerator.writeFieldName("Endpoint").writeValue(elasticsearchDomainStatus.getEndpoint());
            }
            if (elasticsearchDomainStatus.getProcessing() != null) {
                jsonGenerator.writeFieldName("Processing").writeValue(elasticsearchDomainStatus.getProcessing().booleanValue());
            }
            if (elasticsearchDomainStatus.getElasticsearchClusterConfig() != null) {
                jsonGenerator.writeFieldName("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getElasticsearchClusterConfig(), jsonGenerator);
            }
            if (elasticsearchDomainStatus.getEBSOptions() != null) {
                jsonGenerator.writeFieldName("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getEBSOptions(), jsonGenerator);
            }
            if (elasticsearchDomainStatus.getAccessPolicies() != null) {
                jsonGenerator.writeFieldName("AccessPolicies").writeValue(elasticsearchDomainStatus.getAccessPolicies());
            }
            if (elasticsearchDomainStatus.getSnapshotOptions() != null) {
                jsonGenerator.writeFieldName("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(elasticsearchDomainStatus.getSnapshotOptions(), jsonGenerator);
            }
            if ((advancedOptionsMap = elasticsearchDomainStatus.getAdvancedOptions()) != null) {
                jsonGenerator.writeFieldName("AdvancedOptions");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(advancedOptionsMapValue.getKey());
                    jsonGenerator.writeValue(advancedOptionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ElasticsearchDomainStatusJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ElasticsearchDomainStatusJsonMarshaller();
        }
        return instance;
    }
}

