/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringInputStream;
import com.amazonaws.util.StringUtils;
import com.amazonaws.util.json.JSONWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class UpdateElasticsearchDomainConfigRequestMarshaller
implements Marshaller<Request<UpdateElasticsearchDomainConfigRequest>, UpdateElasticsearchDomainConfigRequest> {
    private static final String DEFAULT_CONTENT_TYPE = "";

    public Request<UpdateElasticsearchDomainConfigRequest> marshall(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        if (updateElasticsearchDomainConfigRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateElasticsearchDomainConfigRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}/config";
        uriResourcePath = uriResourcePath.replace("{DomainName}", updateElasticsearchDomainConfigRequest.getDomainName() != null ? StringUtils.fromString((String)updateElasticsearchDomainConfigRequest.getDomainName()) : DEFAULT_CONTENT_TYPE);
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> advancedOptionsMap;
            StringWriter stringWriter = new StringWriter();
            JSONWriter jsonWriter = new JSONWriter((Writer)stringWriter);
            jsonWriter.object();
            if (updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig() != null) {
                jsonWriter.key("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig(), jsonWriter);
            }
            if (updateElasticsearchDomainConfigRequest.getEBSOptions() != null) {
                jsonWriter.key("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getEBSOptions(), jsonWriter);
            }
            if (updateElasticsearchDomainConfigRequest.getSnapshotOptions() != null) {
                jsonWriter.key("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getSnapshotOptions(), jsonWriter);
            }
            if ((advancedOptionsMap = updateElasticsearchDomainConfigRequest.getAdvancedOptions()) != null) {
                jsonWriter.key("AdvancedOptions");
                jsonWriter.object();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonWriter.key(advancedOptionsMapValue.getKey());
                    jsonWriter.value((Object)advancedOptionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            if (updateElasticsearchDomainConfigRequest.getAccessPolicies() != null) {
                jsonWriter.key("AccessPolicies").value((Object)updateElasticsearchDomainConfigRequest.getAccessPolicies());
            }
            jsonWriter.endObject();
            String snippet = stringWriter.toString();
            byte[] content = snippet.getBytes(StringUtils.UTF8);
            request.setContent((InputStream)new StringInputStream(snippet));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", DEFAULT_CONTENT_TYPE);
            }
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

