/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticloadbalancing.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.elasticloadbalancing.model.TagKeyOnly;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RemoveTagsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> loadBalancerNames;
    private ListWithAutoConstructFlag<TagKeyOnly> tags;

    public List<String> getLoadBalancerNames() {
        if (this.loadBalancerNames == null) {
            this.loadBalancerNames = new ListWithAutoConstructFlag();
            this.loadBalancerNames.setAutoConstruct(true);
        }
        return this.loadBalancerNames;
    }

    public void setLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancerNamesCopy = new ListWithAutoConstructFlag(loadBalancerNames.size());
        loadBalancerNamesCopy.addAll(loadBalancerNames);
        this.loadBalancerNames = loadBalancerNamesCopy;
    }

    public RemoveTagsRequest withLoadBalancerNames(String ... loadBalancerNames) {
        if (this.getLoadBalancerNames() == null) {
            this.setLoadBalancerNames(new ArrayList<String>(loadBalancerNames.length));
        }
        for (String value : loadBalancerNames) {
            this.getLoadBalancerNames().add(value);
        }
        return this;
    }

    public RemoveTagsRequest withLoadBalancerNames(Collection<String> loadBalancerNames) {
        if (loadBalancerNames == null) {
            this.loadBalancerNames = null;
        } else {
            ListWithAutoConstructFlag loadBalancerNamesCopy = new ListWithAutoConstructFlag(loadBalancerNames.size());
            loadBalancerNamesCopy.addAll(loadBalancerNames);
            this.loadBalancerNames = loadBalancerNamesCopy;
        }
        return this;
    }

    public List<TagKeyOnly> getTags() {
        if (this.tags == null) {
            this.tags = new ListWithAutoConstructFlag();
            this.tags.setAutoConstruct(true);
        }
        return this.tags;
    }

    public void setTags(Collection<TagKeyOnly> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
        tagsCopy.addAll(tags);
        this.tags = tagsCopy;
    }

    public RemoveTagsRequest withTags(TagKeyOnly ... tags) {
        if (this.getTags() == null) {
            this.setTags(new ArrayList<TagKeyOnly>(tags.length));
        }
        for (TagKeyOnly value : tags) {
            this.getTags().add(value);
        }
        return this;
    }

    public RemoveTagsRequest withTags(Collection<TagKeyOnly> tags) {
        if (tags == null) {
            this.tags = null;
        } else {
            ListWithAutoConstructFlag tagsCopy = new ListWithAutoConstructFlag(tags.size());
            tagsCopy.addAll(tags);
            this.tags = tagsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLoadBalancerNames() != null) {
            sb.append("LoadBalancerNames: " + this.getLoadBalancerNames() + ",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: " + this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLoadBalancerNames() == null ? 0 : this.getLoadBalancerNames().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveTagsRequest)) {
            return false;
        }
        RemoveTagsRequest other = (RemoveTagsRequest)obj;
        if (other.getLoadBalancerNames() == null ^ this.getLoadBalancerNames() == null) {
            return false;
        }
        if (other.getLoadBalancerNames() != null && !other.getLoadBalancerNames().equals(this.getLoadBalancerNames())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public RemoveTagsRequest clone() {
        return (RemoveTagsRequest)super.clone();
    }
}

