/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.elasticbeanstalk.model.DescribeApplicationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class DescribeApplicationsRequestMarshaller
implements Marshaller<Request<DescribeApplicationsRequest>, DescribeApplicationsRequest> {
    public Request<DescribeApplicationsRequest> marshall(DescribeApplicationsRequest describeApplicationsRequest) {
        if (describeApplicationsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeApplicationsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "DescribeApplications");
        request.addParameter("Version", "2010-12-01");
        List<String> applicationNamesList = describeApplicationsRequest.getApplicationNames();
        int applicationNamesListIndex = 1;
        for (String applicationNamesListValue : applicationNamesList) {
            if (applicationNamesListValue != null) {
                request.addParameter("ApplicationNames.member." + applicationNamesListIndex, StringUtils.fromString((String)applicationNamesListValue));
            }
            ++applicationNamesListIndex;
        }
        return request;
    }
}

