/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.ConfigurationOptionSetting;
import com.amazonaws.services.elasticbeanstalk.model.ValidateConfigurationSettingsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ValidateConfigurationSettingsRequestMarshaller
implements Marshaller<Request<ValidateConfigurationSettingsRequest>, ValidateConfigurationSettingsRequest> {
    public Request<ValidateConfigurationSettingsRequest> marshall(ValidateConfigurationSettingsRequest validateConfigurationSettingsRequest) {
        if (validateConfigurationSettingsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)validateConfigurationSettingsRequest, "AWSElasticBeanstalk");
        request.addParameter("Action", "ValidateConfigurationSettings");
        request.addParameter("Version", "2010-12-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (validateConfigurationSettingsRequest.getApplicationName() != null) {
            request.addParameter("ApplicationName", StringUtils.fromString((String)validateConfigurationSettingsRequest.getApplicationName()));
        }
        if (validateConfigurationSettingsRequest.getTemplateName() != null) {
            request.addParameter("TemplateName", StringUtils.fromString((String)validateConfigurationSettingsRequest.getTemplateName()));
        }
        if (validateConfigurationSettingsRequest.getEnvironmentName() != null) {
            request.addParameter("EnvironmentName", StringUtils.fromString((String)validateConfigurationSettingsRequest.getEnvironmentName()));
        }
        if (!validateConfigurationSettingsRequest.getOptionSettings().isEmpty() || !((SdkInternalList)validateConfigurationSettingsRequest.getOptionSettings()).isAutoConstruct()) {
            SdkInternalList optionSettingsList = (SdkInternalList)validateConfigurationSettingsRequest.getOptionSettings();
            int optionSettingsListIndex = 1;
            for (ConfigurationOptionSetting optionSettingsListValue : optionSettingsList) {
                if (optionSettingsListValue.getResourceName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".ResourceName", StringUtils.fromString((String)optionSettingsListValue.getResourceName()));
                }
                if (optionSettingsListValue.getNamespace() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Namespace", StringUtils.fromString((String)optionSettingsListValue.getNamespace()));
                }
                if (optionSettingsListValue.getOptionName() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".OptionName", StringUtils.fromString((String)optionSettingsListValue.getOptionName()));
                }
                if (optionSettingsListValue.getValue() != null) {
                    request.addParameter("OptionSettings.member." + optionSettingsListIndex + ".Value", StringUtils.fromString((String)optionSettingsListValue.getValue()));
                }
                ++optionSettingsListIndex;
            }
        }
        return request;
    }
}

