/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ComposeEnvironmentsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String applicationName;
    private String groupName;
    private SdkInternalList<String> versionLabels;

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public ComposeEnvironmentsRequest withApplicationName(String applicationName) {
        this.setApplicationName(applicationName);
        return this;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public ComposeEnvironmentsRequest withGroupName(String groupName) {
        this.setGroupName(groupName);
        return this;
    }

    public List<String> getVersionLabels() {
        if (this.versionLabels == null) {
            this.versionLabels = new SdkInternalList();
        }
        return this.versionLabels;
    }

    public void setVersionLabels(Collection<String> versionLabels) {
        if (versionLabels == null) {
            this.versionLabels = null;
            return;
        }
        this.versionLabels = new SdkInternalList(versionLabels);
    }

    public ComposeEnvironmentsRequest withVersionLabels(String ... versionLabels) {
        if (this.versionLabels == null) {
            this.setVersionLabels((Collection<String>)new SdkInternalList(versionLabels.length));
        }
        for (String ele : versionLabels) {
            this.versionLabels.add((Object)ele);
        }
        return this;
    }

    public ComposeEnvironmentsRequest withVersionLabels(Collection<String> versionLabels) {
        this.setVersionLabels(versionLabels);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getApplicationName() != null) {
            sb.append("ApplicationName: " + this.getApplicationName() + ",");
        }
        if (this.getGroupName() != null) {
            sb.append("GroupName: " + this.getGroupName() + ",");
        }
        if (this.getVersionLabels() != null) {
            sb.append("VersionLabels: " + this.getVersionLabels());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComposeEnvironmentsRequest)) {
            return false;
        }
        ComposeEnvironmentsRequest other = (ComposeEnvironmentsRequest)obj;
        if (other.getApplicationName() == null ^ this.getApplicationName() == null) {
            return false;
        }
        if (other.getApplicationName() != null && !other.getApplicationName().equals(this.getApplicationName())) {
            return false;
        }
        if (other.getGroupName() == null ^ this.getGroupName() == null) {
            return false;
        }
        if (other.getGroupName() != null && !other.getGroupName().equals(this.getGroupName())) {
            return false;
        }
        if (other.getVersionLabels() == null ^ this.getVersionLabels() == null) {
            return false;
        }
        return other.getVersionLabels() == null || other.getVersionLabels().equals(this.getVersionLabels());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getApplicationName() == null ? 0 : this.getApplicationName().hashCode());
        hashCode = 31 * hashCode + (this.getGroupName() == null ? 0 : this.getGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getVersionLabels() == null ? 0 : this.getVersionLabels().hashCode());
        return hashCode;
    }

    public ComposeEnvironmentsRequest clone() {
        return (ComposeEnvironmentsRequest)super.clone();
    }
}

