/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.eksauth.model;

import java.io.Serializable;
import javax.annotation.Generated;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.protocol.ProtocolMarshaller;

/**
 * <p>
 * An object with the permanent IAM role identity and the temporary session name.
 * </p>
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/eks-auth-2023-11-26/AssumedRoleUser" target="_top">AWS API
 *      Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AssumedRoleUser implements Serializable, Cloneable, StructuredPojo {

    /**
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     */
    private String arn;
    /**
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     */
    private String assumeRoleId;

    /**
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * 
     * @param arn
     *        The ARN of the IAM role that the temporary credentials authenticate to.
     */

    public void setArn(String arn) {
        this.arn = arn;
    }

    /**
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * 
     * @return The ARN of the IAM role that the temporary credentials authenticate to.
     */

    public String getArn() {
        return this.arn;
    }

    /**
     * <p>
     * The ARN of the IAM role that the temporary credentials authenticate to.
     * </p>
     * 
     * @param arn
     *        The ARN of the IAM role that the temporary credentials authenticate to.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumedRoleUser withArn(String arn) {
        setArn(arn);
        return this;
    }

    /**
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @param assumeRoleId
     *        The session name of the temporary session requested to STS. The value is a unique identifier that contains
     *        the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The
     *        role ID is generated by IAM when the role is created. The role session name part of the value follows this
     *        format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */

    public void setAssumeRoleId(String assumeRoleId) {
        this.assumeRoleId = assumeRoleId;
    }

    /**
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @return The session name of the temporary session requested to STS. The value is a unique identifier that
     *         contains the role ID, a colon (<code>:</code>), and the role session name of the role that is being
     *         assumed. The role ID is generated by IAM when the role is created. The role session name part of the
     *         value follows this format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     */

    public String getAssumeRoleId() {
        return this.assumeRoleId;
    }

    /**
     * <p>
     * The session name of the temporary session requested to STS. The value is a unique identifier that contains the
     * role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The role ID is
     * generated by IAM when the role is created. The role session name part of the value follows this format:
     * <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * </p>
     * 
     * @param assumeRoleId
     *        The session name of the temporary session requested to STS. The value is a unique identifier that contains
     *        the role ID, a colon (<code>:</code>), and the role session name of the role that is being assumed. The
     *        role ID is generated by IAM when the role is created. The role session name part of the value follows this
     *        format: <code>eks-<i>clustername</i>-<i>podname</i>-<i>random UUID</i> </code>
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public AssumedRoleUser withAssumeRoleId(String assumeRoleId) {
        setAssumeRoleId(assumeRoleId);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getArn() != null)
            sb.append("Arn: ").append(getArn()).append(",");
        if (getAssumeRoleId() != null)
            sb.append("AssumeRoleId: ").append(getAssumeRoleId());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof AssumedRoleUser == false)
            return false;
        AssumedRoleUser other = (AssumedRoleUser) obj;
        if (other.getArn() == null ^ this.getArn() == null)
            return false;
        if (other.getArn() != null && other.getArn().equals(this.getArn()) == false)
            return false;
        if (other.getAssumeRoleId() == null ^ this.getAssumeRoleId() == null)
            return false;
        if (other.getAssumeRoleId() != null && other.getAssumeRoleId().equals(this.getAssumeRoleId()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getArn() == null) ? 0 : getArn().hashCode());
        hashCode = prime * hashCode + ((getAssumeRoleId() == null) ? 0 : getAssumeRoleId().hashCode());
        return hashCode;
    }

    @Override
    public AssumedRoleUser clone() {
        try {
            return (AssumedRoleUser) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

    @com.amazonaws.annotation.SdkInternalApi
    @Override
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        com.amazonaws.services.eksauth.model.transform.AssumedRoleUserMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}
