/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.eks.model.CreateAccessConfigRequest;
import com.amazonaws.services.eks.model.EncryptionConfig;
import com.amazonaws.services.eks.model.KubernetesNetworkConfigRequest;
import com.amazonaws.services.eks.model.Logging;
import com.amazonaws.services.eks.model.OutpostConfigRequest;
import com.amazonaws.services.eks.model.VpcConfigRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateClusterRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private String version;
    private String roleArn;
    private VpcConfigRequest resourcesVpcConfig;
    private KubernetesNetworkConfigRequest kubernetesNetworkConfig;
    private Logging logging;
    private String clientRequestToken;
    private Map<String, String> tags;
    private List<EncryptionConfig> encryptionConfig;
    private OutpostConfigRequest outpostConfig;
    private CreateAccessConfigRequest accessConfig;
    private Boolean bootstrapSelfManagedAddons;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateClusterRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CreateClusterRequest withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public CreateClusterRequest withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public void setResourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
        this.resourcesVpcConfig = resourcesVpcConfig;
    }

    public VpcConfigRequest getResourcesVpcConfig() {
        return this.resourcesVpcConfig;
    }

    public CreateClusterRequest withResourcesVpcConfig(VpcConfigRequest resourcesVpcConfig) {
        this.setResourcesVpcConfig(resourcesVpcConfig);
        return this;
    }

    public void setKubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
        this.kubernetesNetworkConfig = kubernetesNetworkConfig;
    }

    public KubernetesNetworkConfigRequest getKubernetesNetworkConfig() {
        return this.kubernetesNetworkConfig;
    }

    public CreateClusterRequest withKubernetesNetworkConfig(KubernetesNetworkConfigRequest kubernetesNetworkConfig) {
        this.setKubernetesNetworkConfig(kubernetesNetworkConfig);
        return this;
    }

    public void setLogging(Logging logging) {
        this.logging = logging;
    }

    public Logging getLogging() {
        return this.logging;
    }

    public CreateClusterRequest withLogging(Logging logging) {
        this.setLogging(logging);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateClusterRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateClusterRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateClusterRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateClusterRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public List<EncryptionConfig> getEncryptionConfig() {
        return this.encryptionConfig;
    }

    public void setEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        if (encryptionConfig == null) {
            this.encryptionConfig = null;
            return;
        }
        this.encryptionConfig = new ArrayList<EncryptionConfig>(encryptionConfig);
    }

    public CreateClusterRequest withEncryptionConfig(EncryptionConfig ... encryptionConfig) {
        if (this.encryptionConfig == null) {
            this.setEncryptionConfig(new ArrayList<EncryptionConfig>(encryptionConfig.length));
        }
        for (EncryptionConfig ele : encryptionConfig) {
            this.encryptionConfig.add(ele);
        }
        return this;
    }

    public CreateClusterRequest withEncryptionConfig(Collection<EncryptionConfig> encryptionConfig) {
        this.setEncryptionConfig(encryptionConfig);
        return this;
    }

    public void setOutpostConfig(OutpostConfigRequest outpostConfig) {
        this.outpostConfig = outpostConfig;
    }

    public OutpostConfigRequest getOutpostConfig() {
        return this.outpostConfig;
    }

    public CreateClusterRequest withOutpostConfig(OutpostConfigRequest outpostConfig) {
        this.setOutpostConfig(outpostConfig);
        return this;
    }

    public void setAccessConfig(CreateAccessConfigRequest accessConfig) {
        this.accessConfig = accessConfig;
    }

    public CreateAccessConfigRequest getAccessConfig() {
        return this.accessConfig;
    }

    public CreateClusterRequest withAccessConfig(CreateAccessConfigRequest accessConfig) {
        this.setAccessConfig(accessConfig);
        return this;
    }

    public void setBootstrapSelfManagedAddons(Boolean bootstrapSelfManagedAddons) {
        this.bootstrapSelfManagedAddons = bootstrapSelfManagedAddons;
    }

    public Boolean getBootstrapSelfManagedAddons() {
        return this.bootstrapSelfManagedAddons;
    }

    public CreateClusterRequest withBootstrapSelfManagedAddons(Boolean bootstrapSelfManagedAddons) {
        this.setBootstrapSelfManagedAddons(bootstrapSelfManagedAddons);
        return this;
    }

    public Boolean isBootstrapSelfManagedAddons() {
        return this.bootstrapSelfManagedAddons;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion()).append(",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: ").append(this.getRoleArn()).append(",");
        }
        if (this.getResourcesVpcConfig() != null) {
            sb.append("ResourcesVpcConfig: ").append(this.getResourcesVpcConfig()).append(",");
        }
        if (this.getKubernetesNetworkConfig() != null) {
            sb.append("KubernetesNetworkConfig: ").append(this.getKubernetesNetworkConfig()).append(",");
        }
        if (this.getLogging() != null) {
            sb.append("Logging: ").append(this.getLogging()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getEncryptionConfig() != null) {
            sb.append("EncryptionConfig: ").append(this.getEncryptionConfig()).append(",");
        }
        if (this.getOutpostConfig() != null) {
            sb.append("OutpostConfig: ").append(this.getOutpostConfig()).append(",");
        }
        if (this.getAccessConfig() != null) {
            sb.append("AccessConfig: ").append(this.getAccessConfig()).append(",");
        }
        if (this.getBootstrapSelfManagedAddons() != null) {
            sb.append("BootstrapSelfManagedAddons: ").append(this.getBootstrapSelfManagedAddons());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateClusterRequest)) {
            return false;
        }
        CreateClusterRequest other = (CreateClusterRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        if (other.getVersion() != null && !other.getVersion().equals(this.getVersion())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getResourcesVpcConfig() == null ^ this.getResourcesVpcConfig() == null) {
            return false;
        }
        if (other.getResourcesVpcConfig() != null && !other.getResourcesVpcConfig().equals(this.getResourcesVpcConfig())) {
            return false;
        }
        if (other.getKubernetesNetworkConfig() == null ^ this.getKubernetesNetworkConfig() == null) {
            return false;
        }
        if (other.getKubernetesNetworkConfig() != null && !other.getKubernetesNetworkConfig().equals(this.getKubernetesNetworkConfig())) {
            return false;
        }
        if (other.getLogging() == null ^ this.getLogging() == null) {
            return false;
        }
        if (other.getLogging() != null && !other.getLogging().equals(this.getLogging())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getEncryptionConfig() == null ^ this.getEncryptionConfig() == null) {
            return false;
        }
        if (other.getEncryptionConfig() != null && !other.getEncryptionConfig().equals(this.getEncryptionConfig())) {
            return false;
        }
        if (other.getOutpostConfig() == null ^ this.getOutpostConfig() == null) {
            return false;
        }
        if (other.getOutpostConfig() != null && !other.getOutpostConfig().equals(this.getOutpostConfig())) {
            return false;
        }
        if (other.getAccessConfig() == null ^ this.getAccessConfig() == null) {
            return false;
        }
        if (other.getAccessConfig() != null && !other.getAccessConfig().equals(this.getAccessConfig())) {
            return false;
        }
        if (other.getBootstrapSelfManagedAddons() == null ^ this.getBootstrapSelfManagedAddons() == null) {
            return false;
        }
        return other.getBootstrapSelfManagedAddons() == null || other.getBootstrapSelfManagedAddons().equals(this.getBootstrapSelfManagedAddons());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getResourcesVpcConfig() == null ? 0 : this.getResourcesVpcConfig().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetesNetworkConfig() == null ? 0 : this.getKubernetesNetworkConfig().hashCode());
        hashCode = 31 * hashCode + (this.getLogging() == null ? 0 : this.getLogging().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getEncryptionConfig() == null ? 0 : this.getEncryptionConfig().hashCode());
        hashCode = 31 * hashCode + (this.getOutpostConfig() == null ? 0 : this.getOutpostConfig().hashCode());
        hashCode = 31 * hashCode + (this.getAccessConfig() == null ? 0 : this.getAccessConfig().hashCode());
        hashCode = 31 * hashCode + (this.getBootstrapSelfManagedAddons() == null ? 0 : this.getBootstrapSelfManagedAddons().hashCode());
        return hashCode;
    }

    public CreateClusterRequest clone() {
        return (CreateClusterRequest)super.clone();
    }
}

