/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.eks.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CreateAccessEntryRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String clusterName;
    private String principalArn;
    private List<String> kubernetesGroups;
    private Map<String, String> tags;
    private String clientRequestToken;
    private String username;
    private String type;

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public CreateAccessEntryRequest withClusterName(String clusterName) {
        this.setClusterName(clusterName);
        return this;
    }

    public void setPrincipalArn(String principalArn) {
        this.principalArn = principalArn;
    }

    public String getPrincipalArn() {
        return this.principalArn;
    }

    public CreateAccessEntryRequest withPrincipalArn(String principalArn) {
        this.setPrincipalArn(principalArn);
        return this;
    }

    public List<String> getKubernetesGroups() {
        return this.kubernetesGroups;
    }

    public void setKubernetesGroups(Collection<String> kubernetesGroups) {
        if (kubernetesGroups == null) {
            this.kubernetesGroups = null;
            return;
        }
        this.kubernetesGroups = new ArrayList<String>(kubernetesGroups);
    }

    public CreateAccessEntryRequest withKubernetesGroups(String ... kubernetesGroups) {
        if (this.kubernetesGroups == null) {
            this.setKubernetesGroups(new ArrayList<String>(kubernetesGroups.length));
        }
        for (String ele : kubernetesGroups) {
            this.kubernetesGroups.add(ele);
        }
        return this;
    }

    public CreateAccessEntryRequest withKubernetesGroups(Collection<String> kubernetesGroups) {
        this.setKubernetesGroups(kubernetesGroups);
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }

    public CreateAccessEntryRequest withTags(Map<String, String> tags) {
        this.setTags(tags);
        return this;
    }

    public CreateAccessEntryRequest addTagsEntry(String key, String value) {
        if (null == this.tags) {
            this.tags = new HashMap<String, String>();
        }
        if (this.tags.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.tags.put(key, value);
        return this;
    }

    public CreateAccessEntryRequest clearTagsEntries() {
        this.tags = null;
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateAccessEntryRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUsername() {
        return this.username;
    }

    public CreateAccessEntryRequest withUsername(String username) {
        this.setUsername(username);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateAccessEntryRequest withType(String type) {
        this.setType(type);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClusterName() != null) {
            sb.append("ClusterName: ").append(this.getClusterName()).append(",");
        }
        if (this.getPrincipalArn() != null) {
            sb.append("PrincipalArn: ").append(this.getPrincipalArn()).append(",");
        }
        if (this.getKubernetesGroups() != null) {
            sb.append("KubernetesGroups: ").append(this.getKubernetesGroups()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append(this.getClientRequestToken()).append(",");
        }
        if (this.getUsername() != null) {
            sb.append("Username: ").append(this.getUsername()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessEntryRequest)) {
            return false;
        }
        CreateAccessEntryRequest other = (CreateAccessEntryRequest)obj;
        if (other.getClusterName() == null ^ this.getClusterName() == null) {
            return false;
        }
        if (other.getClusterName() != null && !other.getClusterName().equals(this.getClusterName())) {
            return false;
        }
        if (other.getPrincipalArn() == null ^ this.getPrincipalArn() == null) {
            return false;
        }
        if (other.getPrincipalArn() != null && !other.getPrincipalArn().equals(this.getPrincipalArn())) {
            return false;
        }
        if (other.getKubernetesGroups() == null ^ this.getKubernetesGroups() == null) {
            return false;
        }
        if (other.getKubernetesGroups() != null && !other.getKubernetesGroups().equals(this.getKubernetesGroups())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        if (other.getClientRequestToken() != null && !other.getClientRequestToken().equals(this.getClientRequestToken())) {
            return false;
        }
        if (other.getUsername() == null ^ this.getUsername() == null) {
            return false;
        }
        if (other.getUsername() != null && !other.getUsername().equals(this.getUsername())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        return other.getType() == null || other.getType().equals(this.getType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClusterName() == null ? 0 : this.getClusterName().hashCode());
        hashCode = 31 * hashCode + (this.getPrincipalArn() == null ? 0 : this.getPrincipalArn().hashCode());
        hashCode = 31 * hashCode + (this.getKubernetesGroups() == null ? 0 : this.getKubernetesGroups().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        hashCode = 31 * hashCode + (this.getUsername() == null ? 0 : this.getUsername().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        return hashCode;
    }

    public CreateAccessEntryRequest clone() {
        return (CreateAccessEntryRequest)super.clone();
    }
}

