/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.NetworkConfiguration;
import com.amazonaws.services.ecs.model.Scale;
import com.amazonaws.services.ecs.model.ServiceRegistry;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateTaskSetRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String service;
    private String cluster;
    private String externalId;
    private String taskDefinition;
    private NetworkConfiguration networkConfiguration;
    private SdkInternalList<LoadBalancer> loadBalancers;
    private SdkInternalList<ServiceRegistry> serviceRegistries;
    private String launchType;
    private String platformVersion;
    private Scale scale;
    private String clientToken;

    public void setService(String service) {
        this.service = service;
    }

    public String getService() {
        return this.service;
    }

    public CreateTaskSetRequest withService(String service) {
        this.setService(service);
        return this;
    }

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public CreateTaskSetRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public void setExternalId(String externalId) {
        this.externalId = externalId;
    }

    public String getExternalId() {
        return this.externalId;
    }

    public CreateTaskSetRequest withExternalId(String externalId) {
        this.setExternalId(externalId);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public CreateTaskSetRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public CreateTaskSetRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new SdkInternalList();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        this.loadBalancers = new SdkInternalList(loadBalancers);
    }

    public CreateTaskSetRequest withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.loadBalancers == null) {
            this.setLoadBalancers((Collection<LoadBalancer>)new SdkInternalList(loadBalancers.length));
        }
        for (LoadBalancer ele : loadBalancers) {
            this.loadBalancers.add((Object)ele);
        }
        return this;
    }

    public CreateTaskSetRequest withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        this.setLoadBalancers(loadBalancers);
        return this;
    }

    public List<ServiceRegistry> getServiceRegistries() {
        if (this.serviceRegistries == null) {
            this.serviceRegistries = new SdkInternalList();
        }
        return this.serviceRegistries;
    }

    public void setServiceRegistries(Collection<ServiceRegistry> serviceRegistries) {
        if (serviceRegistries == null) {
            this.serviceRegistries = null;
            return;
        }
        this.serviceRegistries = new SdkInternalList(serviceRegistries);
    }

    public CreateTaskSetRequest withServiceRegistries(ServiceRegistry ... serviceRegistries) {
        if (this.serviceRegistries == null) {
            this.setServiceRegistries((Collection<ServiceRegistry>)new SdkInternalList(serviceRegistries.length));
        }
        for (ServiceRegistry ele : serviceRegistries) {
            this.serviceRegistries.add((Object)ele);
        }
        return this;
    }

    public CreateTaskSetRequest withServiceRegistries(Collection<ServiceRegistry> serviceRegistries) {
        this.setServiceRegistries(serviceRegistries);
        return this;
    }

    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    public CreateTaskSetRequest withLaunchType(String launchType) {
        this.setLaunchType(launchType);
        return this;
    }

    public CreateTaskSetRequest withLaunchType(LaunchType launchType) {
        this.launchType = launchType.toString();
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public CreateTaskSetRequest withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setScale(Scale scale) {
        this.scale = scale;
    }

    public Scale getScale() {
        return this.scale;
    }

    public CreateTaskSetRequest withScale(Scale scale) {
        this.setScale(scale);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateTaskSetRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getService() != null) {
            sb.append("Service: ").append(this.getService()).append(",");
        }
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getExternalId() != null) {
            sb.append("ExternalId: ").append(this.getExternalId()).append(",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: ").append(this.getTaskDefinition()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: ").append(this.getLoadBalancers()).append(",");
        }
        if (this.getServiceRegistries() != null) {
            sb.append("ServiceRegistries: ").append(this.getServiceRegistries()).append(",");
        }
        if (this.getLaunchType() != null) {
            sb.append("LaunchType: ").append(this.getLaunchType()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getScale() != null) {
            sb.append("Scale: ").append(this.getScale()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTaskSetRequest)) {
            return false;
        }
        CreateTaskSetRequest other = (CreateTaskSetRequest)obj;
        if (other.getService() == null ^ this.getService() == null) {
            return false;
        }
        if (other.getService() != null && !other.getService().equals(this.getService())) {
            return false;
        }
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getExternalId() == null ^ this.getExternalId() == null) {
            return false;
        }
        if (other.getExternalId() != null && !other.getExternalId().equals(this.getExternalId())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getServiceRegistries() == null ^ this.getServiceRegistries() == null) {
            return false;
        }
        if (other.getServiceRegistries() != null && !other.getServiceRegistries().equals(this.getServiceRegistries())) {
            return false;
        }
        if (other.getLaunchType() == null ^ this.getLaunchType() == null) {
            return false;
        }
        if (other.getLaunchType() != null && !other.getLaunchType().equals(this.getLaunchType())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getScale() == null ^ this.getScale() == null) {
            return false;
        }
        if (other.getScale() != null && !other.getScale().equals(this.getScale())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getService() == null ? 0 : this.getService().hashCode());
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getExternalId() == null ? 0 : this.getExternalId().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getServiceRegistries() == null ? 0 : this.getServiceRegistries().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchType() == null ? 0 : this.getLaunchType().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getScale() == null ? 0 : this.getScale().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateTaskSetRequest clone() {
        return (CreateTaskSetRequest)super.clone();
    }
}

