/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.AmazonWebServiceResponse;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.ClientConfigurationFactory;
import com.amazonaws.Request;
import com.amazonaws.Response;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsSyncClientParams;
import com.amazonaws.handlers.HandlerChainFactory;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpResponseHandler;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.protocol.json.JsonClientMetadata;
import com.amazonaws.protocol.json.JsonErrorResponseMetadata;
import com.amazonaws.protocol.json.JsonErrorShapeMetadata;
import com.amazonaws.protocol.json.JsonOperationMetadata;
import com.amazonaws.protocol.json.SdkJsonProtocolFactory;
import com.amazonaws.services.ecr.AmazonECR;
import com.amazonaws.services.ecr.model.AmazonECRException;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.BatchDeleteImageResult;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.BatchGetImageResult;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecr.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.EmptyUploadException;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerResult;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.ImageAlreadyExistsException;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecr.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecr.model.InvalidLayerException;
import com.amazonaws.services.ecr.model.InvalidLayerPartException;
import com.amazonaws.services.ecr.model.InvalidParameterException;
import com.amazonaws.services.ecr.model.LayerAlreadyExistsException;
import com.amazonaws.services.ecr.model.LayerInaccessibleException;
import com.amazonaws.services.ecr.model.LayerPartTooSmallException;
import com.amazonaws.services.ecr.model.LayersNotFoundException;
import com.amazonaws.services.ecr.model.LimitExceededException;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.ListImagesResult;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.services.ecr.model.PutImageResult;
import com.amazonaws.services.ecr.model.RepositoryAlreadyExistsException;
import com.amazonaws.services.ecr.model.RepositoryNotEmptyException;
import com.amazonaws.services.ecr.model.RepositoryNotFoundException;
import com.amazonaws.services.ecr.model.RepositoryPolicyNotFoundException;
import com.amazonaws.services.ecr.model.ServerException;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.services.ecr.model.UploadLayerPartResult;
import com.amazonaws.services.ecr.model.UploadNotFoundException;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchCheckLayerAvailabilityResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchDeleteImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.BatchGetImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.CompleteLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.CreateRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DeleteRepositoryResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.DescribeRepositoriesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetAuthorizationTokenResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetDownloadUrlForLayerResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.GetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.InitiateLayerUploadResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.ListImagesResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.PutImageResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.SetRepositoryPolicyResultJsonUnmarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartRequestMarshaller;
import com.amazonaws.services.ecr.model.transform.UploadLayerPartResultJsonUnmarshaller;
import com.amazonaws.transform.Unmarshaller;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.CredentialUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@ThreadSafe
public class AmazonECRClient
extends AmazonWebServiceClient
implements AmazonECR {
    private final AWSCredentialsProvider awsCredentialsProvider;
    private static final Log log = LogFactory.getLog(AmazonECR.class);
    private static final String DEFAULT_SIGNING_NAME = "ecr";
    protected static final ClientConfigurationFactory configFactory = new ClientConfigurationFactory();
    private final SdkJsonProtocolFactory protocolFactory = new SdkJsonProtocolFactory(new JsonClientMetadata().withProtocolVersion("1.1").withSupportsCbor(false).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerPartTooSmallException").withModeledClass(LayerPartTooSmallException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerPartException").withModeledClass(InvalidLayerPartException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidParameterException").withModeledClass(InvalidParameterException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withModeledClass(ServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotEmptyException").withModeledClass(RepositoryNotEmptyException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerAlreadyExistsException").withModeledClass(LayerAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("EmptyUploadException").withModeledClass(EmptyUploadException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayersNotFoundException").withModeledClass(LayersNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("InvalidLayerException").withModeledClass(InvalidLayerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryNotFoundException").withModeledClass(RepositoryNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryAlreadyExistsException").withModeledClass(RepositoryAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("RepositoryPolicyNotFoundException").withModeledClass(RepositoryPolicyNotFoundException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ImageAlreadyExistsException").withModeledClass(ImageAlreadyExistsException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LayerInaccessibleException").withModeledClass(LayerInaccessibleException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("LimitExceededException").withModeledClass(LimitExceededException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("UploadNotFoundException").withModeledClass(UploadNotFoundException.class)).withBaseServiceExceptionClass(AmazonECRException.class));

    public AmazonECRClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), configFactory.getConfig());
    }

    public AmazonECRClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration);
    }

    public AmazonECRClient(AWSCredentials awsCredentials) {
        this(awsCredentials, configFactory.getConfig());
    }

    public AmazonECRClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.awsCredentialsProvider = new StaticCredentialsProvider(awsCredentials);
        this.init();
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, configFactory.getConfig());
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, null);
    }

    public AmazonECRClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        super(clientConfiguration, requestMetricCollector);
        this.awsCredentialsProvider = awsCredentialsProvider;
        this.init();
    }

    AmazonECRClient(AwsSyncClientParams clientParams) {
        super(clientParams);
        this.awsCredentialsProvider = clientParams.getCredentialsProvider();
        this.init();
    }

    private void init() {
        this.setServiceNameIntern(DEFAULT_SIGNING_NAME);
        this.setEndpointPrefix(DEFAULT_SIGNING_NAME);
        this.setEndpoint("ecr.us-east-1.amazonaws.com");
        HandlerChainFactory chainFactory = new HandlerChainFactory();
        this.requestHandler2s.addAll(chainFactory.newRequestHandlerChain("/com/amazonaws/services/ecr/request.handlers"));
        this.requestHandler2s.addAll(chainFactory.newRequestHandler2Chain("/com/amazonaws/services/ecr/request.handler2s"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchCheckLayerAvailabilityResult batchCheckLayerAvailability(BatchCheckLayerAvailabilityRequest batchCheckLayerAvailabilityRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchCheckLayerAvailabilityRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchCheckLayerAvailabilityRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchCheckLayerAvailabilityRequestMarshaller(this.protocolFactory).marshall((BatchCheckLayerAvailabilityRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchCheckLayerAvailabilityRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchCheckLayerAvailabilityResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchCheckLayerAvailabilityResult batchCheckLayerAvailabilityResult = (BatchCheckLayerAvailabilityResult)response.getAwsResponse();
            return batchCheckLayerAvailabilityResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchDeleteImageResult batchDeleteImage(BatchDeleteImageRequest batchDeleteImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchDeleteImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchDeleteImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchDeleteImageRequestMarshaller(this.protocolFactory).marshall((BatchDeleteImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchDeleteImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchDeleteImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchDeleteImageResult batchDeleteImageResult = (BatchDeleteImageResult)response.getAwsResponse();
            return batchDeleteImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BatchGetImageResult batchGetImage(BatchGetImageRequest batchGetImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(batchGetImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<BatchGetImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new BatchGetImageRequestMarshaller(this.protocolFactory).marshall((BatchGetImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)batchGetImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new BatchGetImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            BatchGetImageResult batchGetImageResult = (BatchGetImageResult)response.getAwsResponse();
            return batchGetImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompleteLayerUploadResult completeLayerUpload(CompleteLayerUploadRequest completeLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(completeLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CompleteLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CompleteLayerUploadRequestMarshaller(this.protocolFactory).marshall((CompleteLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)completeLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CompleteLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CompleteLayerUploadResult completeLayerUploadResult = (CompleteLayerUploadResult)response.getAwsResponse();
            return completeLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateRepositoryResult createRepository(CreateRepositoryRequest createRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(createRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<CreateRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new CreateRepositoryRequestMarshaller(this.protocolFactory).marshall((CreateRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)createRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            CreateRepositoryResult createRepositoryResult = (CreateRepositoryResult)response.getAwsResponse();
            return createRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryResult deleteRepository(DeleteRepositoryRequest deleteRepositoryRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryRequestMarshaller(this.protocolFactory).marshall((DeleteRepositoryRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRepositoryResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryResult deleteRepositoryResult = (DeleteRepositoryResult)response.getAwsResponse();
            return deleteRepositoryResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteRepositoryPolicyResult deleteRepositoryPolicy(DeleteRepositoryPolicyRequest deleteRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(deleteRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DeleteRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DeleteRepositoryPolicyRequestMarshaller(this.protocolFactory).marshall((DeleteRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)deleteRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DeleteRepositoryPolicyResult deleteRepositoryPolicyResult = (DeleteRepositoryPolicyResult)response.getAwsResponse();
            return deleteRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DescribeRepositoriesResult describeRepositories(DescribeRepositoriesRequest describeRepositoriesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(describeRepositoriesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<DescribeRepositoriesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new DescribeRepositoriesRequestMarshaller(this.protocolFactory).marshall((DescribeRepositoriesRequest)super.beforeMarshalling((AmazonWebServiceRequest)describeRepositoriesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeRepositoriesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            DescribeRepositoriesResult describeRepositoriesResult = (DescribeRepositoriesResult)response.getAwsResponse();
            return describeRepositoriesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetAuthorizationTokenResult getAuthorizationToken(GetAuthorizationTokenRequest getAuthorizationTokenRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getAuthorizationTokenRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetAuthorizationTokenRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetAuthorizationTokenRequestMarshaller(this.protocolFactory).marshall((GetAuthorizationTokenRequest)super.beforeMarshalling((AmazonWebServiceRequest)getAuthorizationTokenRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetAuthorizationTokenResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetAuthorizationTokenResult getAuthorizationTokenResult = (GetAuthorizationTokenResult)response.getAwsResponse();
            return getAuthorizationTokenResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetDownloadUrlForLayerResult getDownloadUrlForLayer(GetDownloadUrlForLayerRequest getDownloadUrlForLayerRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getDownloadUrlForLayerRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetDownloadUrlForLayerRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetDownloadUrlForLayerRequestMarshaller(this.protocolFactory).marshall((GetDownloadUrlForLayerRequest)super.beforeMarshalling((AmazonWebServiceRequest)getDownloadUrlForLayerRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetDownloadUrlForLayerResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetDownloadUrlForLayerResult getDownloadUrlForLayerResult = (GetDownloadUrlForLayerResult)response.getAwsResponse();
            return getDownloadUrlForLayerResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetRepositoryPolicyResult getRepositoryPolicy(GetRepositoryPolicyRequest getRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(getRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<GetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new GetRepositoryPolicyRequestMarshaller(this.protocolFactory).marshall((GetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)getRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new GetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            GetRepositoryPolicyResult getRepositoryPolicyResult = (GetRepositoryPolicyResult)response.getAwsResponse();
            return getRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InitiateLayerUploadResult initiateLayerUpload(InitiateLayerUploadRequest initiateLayerUploadRequest) {
        ExecutionContext executionContext = this.createExecutionContext(initiateLayerUploadRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<InitiateLayerUploadRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new InitiateLayerUploadRequestMarshaller(this.protocolFactory).marshall((InitiateLayerUploadRequest)super.beforeMarshalling((AmazonWebServiceRequest)initiateLayerUploadRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new InitiateLayerUploadResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            InitiateLayerUploadResult initiateLayerUploadResult = (InitiateLayerUploadResult)response.getAwsResponse();
            return initiateLayerUploadResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListImagesResult listImages(ListImagesRequest listImagesRequest) {
        ExecutionContext executionContext = this.createExecutionContext(listImagesRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<ListImagesRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new ListImagesRequestMarshaller(this.protocolFactory).marshall((ListImagesRequest)super.beforeMarshalling((AmazonWebServiceRequest)listImagesRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListImagesResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            ListImagesResult listImagesResult = (ListImagesResult)response.getAwsResponse();
            return listImagesResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutImageResult putImage(PutImageRequest putImageRequest) {
        ExecutionContext executionContext = this.createExecutionContext(putImageRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<PutImageRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new PutImageRequestMarshaller(this.protocolFactory).marshall((PutImageRequest)super.beforeMarshalling((AmazonWebServiceRequest)putImageRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new PutImageResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            PutImageResult putImageResult = (PutImageResult)response.getAwsResponse();
            return putImageResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SetRepositoryPolicyResult setRepositoryPolicy(SetRepositoryPolicyRequest setRepositoryPolicyRequest) {
        ExecutionContext executionContext = this.createExecutionContext(setRepositoryPolicyRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<SetRepositoryPolicyRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new SetRepositoryPolicyRequestMarshaller(this.protocolFactory).marshall((SetRepositoryPolicyRequest)super.beforeMarshalling((AmazonWebServiceRequest)setRepositoryPolicyRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SetRepositoryPolicyResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            SetRepositoryPolicyResult setRepositoryPolicyResult = (SetRepositoryPolicyResult)response.getAwsResponse();
            return setRepositoryPolicyResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UploadLayerPartResult uploadLayerPart(UploadLayerPartRequest uploadLayerPartRequest) {
        ExecutionContext executionContext = this.createExecutionContext(uploadLayerPartRequest);
        AWSRequestMetrics awsRequestMetrics = executionContext.getAwsRequestMetrics();
        awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.ClientExecuteTime);
        Request<UploadLayerPartRequest> request = null;
        Response response = null;
        try {
            awsRequestMetrics.startEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            try {
                request = new UploadLayerPartRequestMarshaller(this.protocolFactory).marshall((UploadLayerPartRequest)super.beforeMarshalling((AmazonWebServiceRequest)uploadLayerPartRequest));
                request.setAWSRequestMetrics(awsRequestMetrics);
            }
            finally {
                awsRequestMetrics.endEvent((MetricType)AWSRequestMetrics.Field.RequestMarshallTime);
            }
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UploadLayerPartResultJsonUnmarshaller());
            response = this.invoke(request, responseHandler, executionContext);
            UploadLayerPartResult uploadLayerPartResult = (UploadLayerPartResult)response.getAwsResponse();
            return uploadLayerPartResult;
        }
        finally {
            this.endClientExecution(awsRequestMetrics, request, response);
        }
    }

    @Override
    public ResponseMetadata getCachedResponseMetadata(AmazonWebServiceRequest request) {
        return this.client.getResponseMetadataForRequest(request);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> invoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        executionContext.setCredentialsProvider(CredentialUtils.getCredentialsProvider((AmazonWebServiceRequest)request.getOriginalRequest(), (AWSCredentialsProvider)this.awsCredentialsProvider));
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> anonymousInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        return this.doInvoke(request, responseHandler, executionContext);
    }

    private <X, Y extends AmazonWebServiceRequest> Response<X> doInvoke(Request<Y> request, HttpResponseHandler<AmazonWebServiceResponse<X>> responseHandler, ExecutionContext executionContext) {
        request.setEndpoint(this.endpoint);
        request.setTimeOffset(this.timeOffset);
        HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
        return this.client.execute(request, responseHandler, errorResponseHandler, executionContext);
    }
}

