/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.ClientData;
import com.amazonaws.services.ec2.model.ImageDiskContainer;
import com.amazonaws.services.ec2.model.ImportImageRequest;
import com.amazonaws.services.ec2.model.UserBucket;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.List;

public class ImportImageRequestMarshaller
implements Marshaller<Request<ImportImageRequest>, ImportImageRequest> {
    public Request<ImportImageRequest> marshall(ImportImageRequest importImageRequest) {
        ClientData clientDataClientData;
        if (importImageRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importImageRequest, "AmazonEC2");
        request.addParameter("Action", "ImportImage");
        request.addParameter("Version", "2015-03-01");
        if (importImageRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importImageRequest.getDescription()));
        }
        List<ImageDiskContainer> diskContainersList = importImageRequest.getDiskContainers();
        int diskContainersListIndex = 1;
        for (ImageDiskContainer diskContainersListValue : diskContainersList) {
            ImageDiskContainer imageDiskContainerMember = diskContainersListValue;
            if (imageDiskContainerMember != null) {
                UserBucket userBucketUserBucket;
                if (imageDiskContainerMember.getDescription() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Description", StringUtils.fromString((String)imageDiskContainerMember.getDescription()));
                }
                if (imageDiskContainerMember.getFormat() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Format", StringUtils.fromString((String)imageDiskContainerMember.getFormat()));
                }
                if (imageDiskContainerMember.getUrl() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".Url", StringUtils.fromString((String)imageDiskContainerMember.getUrl()));
                }
                if ((userBucketUserBucket = imageDiskContainerMember.getUserBucket()) != null) {
                    if (userBucketUserBucket.getS3Bucket() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Bucket", StringUtils.fromString((String)userBucketUserBucket.getS3Bucket()));
                    }
                    if (userBucketUserBucket.getS3Key() != null) {
                        request.addParameter("DiskContainer." + diskContainersListIndex + ".UserBucket.S3Key", StringUtils.fromString((String)userBucketUserBucket.getS3Key()));
                    }
                }
                if (imageDiskContainerMember.getDeviceName() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".DeviceName", StringUtils.fromString((String)imageDiskContainerMember.getDeviceName()));
                }
                if (imageDiskContainerMember.getSnapshotId() != null) {
                    request.addParameter("DiskContainer." + diskContainersListIndex + ".SnapshotId", StringUtils.fromString((String)imageDiskContainerMember.getSnapshotId()));
                }
            }
            ++diskContainersListIndex;
        }
        if (importImageRequest.getLicenseType() != null) {
            request.addParameter("LicenseType", StringUtils.fromString((String)importImageRequest.getLicenseType()));
        }
        if (importImageRequest.getHypervisor() != null) {
            request.addParameter("Hypervisor", StringUtils.fromString((String)importImageRequest.getHypervisor()));
        }
        if (importImageRequest.getArchitecture() != null) {
            request.addParameter("Architecture", StringUtils.fromString((String)importImageRequest.getArchitecture()));
        }
        if (importImageRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importImageRequest.getPlatform()));
        }
        if ((clientDataClientData = importImageRequest.getClientData()) != null) {
            if (clientDataClientData.getUploadStart() != null) {
                request.addParameter("ClientData.UploadStart", StringUtils.fromDate((Date)clientDataClientData.getUploadStart()));
            }
            if (clientDataClientData.getUploadEnd() != null) {
                request.addParameter("ClientData.UploadEnd", StringUtils.fromDate((Date)clientDataClientData.getUploadEnd()));
            }
            if (clientDataClientData.getUploadSize() != null) {
                request.addParameter("ClientData.UploadSize", StringUtils.fromDouble((Double)clientDataClientData.getUploadSize()));
            }
            if (clientDataClientData.getComment() != null) {
                request.addParameter("ClientData.Comment", StringUtils.fromString((String)clientDataClientData.getComment()));
            }
        }
        if (importImageRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)importImageRequest.getClientToken()));
        }
        if (importImageRequest.getRoleName() != null) {
            request.addParameter("RoleName", StringUtils.fromString((String)importImageRequest.getRoleName()));
        }
        return request;
    }
}

