/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DiskImage;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportInstanceLaunchSpecification;
import com.amazonaws.services.ec2.model.ImportInstanceRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.UserData;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ImportInstanceRequestMarshaller
implements Marshaller<Request<ImportInstanceRequest>, ImportInstanceRequest> {
    public Request<ImportInstanceRequest> marshall(ImportInstanceRequest importInstanceRequest) {
        ImportInstanceLaunchSpecification importInstanceLaunchSpecificationLaunchSpecification;
        if (importInstanceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importInstanceRequest, "AmazonEC2");
        request.addParameter("Action", "ImportInstance");
        request.addParameter("Version", "2014-10-01");
        if (importInstanceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importInstanceRequest.getDescription()));
        }
        if ((importInstanceLaunchSpecificationLaunchSpecification = importInstanceRequest.getLaunchSpecification()) != null) {
            Placement placementPlacement;
            UserData userDataUserData;
            if (importInstanceLaunchSpecificationLaunchSpecification.getArchitecture() != null) {
                request.addParameter("LaunchSpecification.Architecture", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getArchitecture()));
            }
            List<String> groupNamesList = importInstanceLaunchSpecificationLaunchSpecification.getGroupNames();
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("LaunchSpecification.GroupName." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
            List<String> groupIdsList = importInstanceLaunchSpecificationLaunchSpecification.getGroupIds();
            int groupIdsListIndex = 1;
            for (String groupIdsListValue : groupIdsList) {
                if (groupIdsListValue != null) {
                    request.addParameter("LaunchSpecification.GroupId." + groupIdsListIndex, StringUtils.fromString((String)groupIdsListValue));
                }
                ++groupIdsListIndex;
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.getAdditionalInfo() != null) {
                request.addParameter("LaunchSpecification.AdditionalInfo", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getAdditionalInfo()));
            }
            if ((userDataUserData = importInstanceLaunchSpecificationLaunchSpecification.getUserData()) != null && userDataUserData.getData() != null) {
                request.addParameter("LaunchSpecification.UserData.Data", StringUtils.fromString((String)userDataUserData.getData()));
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getInstanceType()));
            }
            if ((placementPlacement = importInstanceLaunchSpecificationLaunchSpecification.getPlacement()) != null) {
                if (placementPlacement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placementPlacement.getAvailabilityZone()));
                }
                if (placementPlacement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placementPlacement.getGroupName()));
                }
                if (placementPlacement.getTenancy() != null) {
                    request.addParameter("LaunchSpecification.Placement.Tenancy", StringUtils.fromString((String)placementPlacement.getTenancy()));
                }
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.isMonitoring() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)importInstanceLaunchSpecificationLaunchSpecification.isMonitoring()));
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getSubnetId()));
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.getInstanceInitiatedShutdownBehavior() != null) {
                request.addParameter("LaunchSpecification.InstanceInitiatedShutdownBehavior", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getInstanceInitiatedShutdownBehavior()));
            }
            if (importInstanceLaunchSpecificationLaunchSpecification.getPrivateIpAddress() != null) {
                request.addParameter("LaunchSpecification.PrivateIpAddress", StringUtils.fromString((String)importInstanceLaunchSpecificationLaunchSpecification.getPrivateIpAddress()));
            }
        }
        List<DiskImage> diskImagesList = importInstanceRequest.getDiskImages();
        int diskImagesListIndex = 1;
        for (DiskImage diskImagesListValue : diskImagesList) {
            DiskImage diskImageMember = diskImagesListValue;
            if (diskImageMember != null) {
                VolumeDetail volumeDetailVolume;
                DiskImageDetail diskImageDetailImage = diskImageMember.getImage();
                if (diskImageDetailImage != null) {
                    if (diskImageDetailImage.getFormat() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Format", StringUtils.fromString((String)diskImageDetailImage.getFormat()));
                    }
                    if (diskImageDetailImage.getBytes() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.Bytes", StringUtils.fromLong((Long)diskImageDetailImage.getBytes()));
                    }
                    if (diskImageDetailImage.getImportManifestUrl() != null) {
                        request.addParameter("DiskImage." + diskImagesListIndex + ".Image.ImportManifestUrl", StringUtils.fromString((String)diskImageDetailImage.getImportManifestUrl()));
                    }
                }
                if (diskImageMember.getDescription() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Description", StringUtils.fromString((String)diskImageMember.getDescription()));
                }
                if ((volumeDetailVolume = diskImageMember.getVolume()) != null && volumeDetailVolume.getSize() != null) {
                    request.addParameter("DiskImage." + diskImagesListIndex + ".Volume.Size", StringUtils.fromLong((Long)volumeDetailVolume.getSize()));
                }
            }
            ++diskImagesListIndex;
        }
        if (importInstanceRequest.getPlatform() != null) {
            request.addParameter("Platform", StringUtils.fromString((String)importInstanceRequest.getPlatform()));
        }
        return request;
    }
}

