/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateTransitGatewayConnectPeerRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.TransitGatewayConnectRequestBgpOptions;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateTransitGatewayConnectPeerRequestMarshaller
implements Marshaller<Request<CreateTransitGatewayConnectPeerRequest>, CreateTransitGatewayConnectPeerRequest> {
    public Request<CreateTransitGatewayConnectPeerRequest> marshall(CreateTransitGatewayConnectPeerRequest createTransitGatewayConnectPeerRequest) {
        SdkInternalList createTransitGatewayConnectPeerRequestTagSpecificationsList;
        SdkInternalList createTransitGatewayConnectPeerRequestInsideCidrBlocksList;
        TransitGatewayConnectRequestBgpOptions bgpOptions;
        if (createTransitGatewayConnectPeerRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createTransitGatewayConnectPeerRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTransitGatewayConnectPeer");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTransitGatewayConnectPeerRequest.getTransitGatewayAttachmentId() != null) {
            request.addParameter("TransitGatewayAttachmentId", StringUtils.fromString((String)createTransitGatewayConnectPeerRequest.getTransitGatewayAttachmentId()));
        }
        if (createTransitGatewayConnectPeerRequest.getTransitGatewayAddress() != null) {
            request.addParameter("TransitGatewayAddress", StringUtils.fromString((String)createTransitGatewayConnectPeerRequest.getTransitGatewayAddress()));
        }
        if (createTransitGatewayConnectPeerRequest.getPeerAddress() != null) {
            request.addParameter("PeerAddress", StringUtils.fromString((String)createTransitGatewayConnectPeerRequest.getPeerAddress()));
        }
        if ((bgpOptions = createTransitGatewayConnectPeerRequest.getBgpOptions()) != null && bgpOptions.getPeerAsn() != null) {
            request.addParameter("BgpOptions.PeerAsn", StringUtils.fromLong((Long)bgpOptions.getPeerAsn()));
        }
        if (!(createTransitGatewayConnectPeerRequestInsideCidrBlocksList = (SdkInternalList)createTransitGatewayConnectPeerRequest.getInsideCidrBlocks()).isEmpty() || !createTransitGatewayConnectPeerRequestInsideCidrBlocksList.isAutoConstruct()) {
            int insideCidrBlocksListIndex = 1;
            for (String createTransitGatewayConnectPeerRequestInsideCidrBlocksListValue : createTransitGatewayConnectPeerRequestInsideCidrBlocksList) {
                if (createTransitGatewayConnectPeerRequestInsideCidrBlocksListValue != null) {
                    request.addParameter("InsideCidrBlocks." + insideCidrBlocksListIndex, StringUtils.fromString((String)createTransitGatewayConnectPeerRequestInsideCidrBlocksListValue));
                }
                ++insideCidrBlocksListIndex;
            }
        }
        if (!(createTransitGatewayConnectPeerRequestTagSpecificationsList = (SdkInternalList)createTransitGatewayConnectPeerRequest.getTagSpecifications()).isEmpty() || !createTransitGatewayConnectPeerRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createTransitGatewayConnectPeerRequestTagSpecificationsListValue : createTransitGatewayConnectPeerRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createTransitGatewayConnectPeerRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createTransitGatewayConnectPeerRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createTransitGatewayConnectPeerRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

