/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.CloudWatchLogOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CloudWatchLogOptionsStaxUnmarshaller
implements Unmarshaller<CloudWatchLogOptions, StaxUnmarshallerContext> {
    private static CloudWatchLogOptionsStaxUnmarshaller instance;

    public CloudWatchLogOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        CloudWatchLogOptions cloudWatchLogOptions = new CloudWatchLogOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return cloudWatchLogOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("logEnabled", targetDepth)) {
                    cloudWatchLogOptions.setLogEnabled(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("logGroupArn", targetDepth)) {
                    cloudWatchLogOptions.setLogGroupArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("logOutputFormat", targetDepth)) continue;
                cloudWatchLogOptions.setLogOutputFormat(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return cloudWatchLogOptions;
    }

    public static CloudWatchLogOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CloudWatchLogOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

