/*
 * Copyright 2018-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.ec2.model.transform;

import java.util.ArrayList;

import javax.xml.stream.events.XMLEvent;
import javax.annotation.Generated;

import com.amazonaws.services.ec2.model.*;
import com.amazonaws.transform.Unmarshaller;

import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers.*;

/**
 * PathComponent StAX Unmarshaller
 */

@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class PathComponentStaxUnmarshaller implements Unmarshaller<PathComponent, StaxUnmarshallerContext> {

    public PathComponent unmarshall(StaxUnmarshallerContext context) throws Exception {
        PathComponent pathComponent = new PathComponent();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;

        if (context.isStartOfDocument())
            targetDepth += 1;

        while (true) {
            XMLEvent xmlEvent = context.nextEvent();
            if (xmlEvent.isEndDocument())
                return pathComponent;

            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {

                if (context.testExpression("sequenceNumber", targetDepth)) {
                    pathComponent.setSequenceNumber(IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("aclRule", targetDepth)) {
                    pathComponent.setAclRule(AnalysisAclRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("attachedTo", targetDepth)) {
                    pathComponent.setAttachedTo(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("component", targetDepth)) {
                    pathComponent.setComponent(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("destinationVpc", targetDepth)) {
                    pathComponent.setDestinationVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("outboundHeader", targetDepth)) {
                    pathComponent.setOutboundHeader(AnalysisPacketHeaderStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("inboundHeader", targetDepth)) {
                    pathComponent.setInboundHeader(AnalysisPacketHeaderStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("routeTableRoute", targetDepth)) {
                    pathComponent.setRouteTableRoute(AnalysisRouteTableRouteStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("securityGroupRule", targetDepth)) {
                    pathComponent.setSecurityGroupRule(AnalysisSecurityGroupRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("sourceVpc", targetDepth)) {
                    pathComponent.setSourceVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("subnet", targetDepth)) {
                    pathComponent.setSubnet(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("vpc", targetDepth)) {
                    pathComponent.setVpc(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("additionalDetailSet", targetDepth)) {
                    pathComponent.withAdditionalDetails(new ArrayList<AdditionalDetail>());
                    continue;
                }

                if (context.testExpression("additionalDetailSet/item", targetDepth)) {
                    pathComponent.withAdditionalDetails(AdditionalDetailStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("transitGateway", targetDepth)) {
                    pathComponent.setTransitGateway(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("transitGatewayRouteTableRoute", targetDepth)) {
                    pathComponent.setTransitGatewayRouteTableRoute(TransitGatewayRouteTableRouteStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("explanationSet", targetDepth)) {
                    pathComponent.withExplanations(new ArrayList<Explanation>());
                    continue;
                }

                if (context.testExpression("explanationSet/item", targetDepth)) {
                    pathComponent.withExplanations(ExplanationStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("elasticLoadBalancerListener", targetDepth)) {
                    pathComponent.setElasticLoadBalancerListener(AnalysisComponentStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("firewallStatelessRule", targetDepth)) {
                    pathComponent.setFirewallStatelessRule(FirewallStatelessRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("firewallStatefulRule", targetDepth)) {
                    pathComponent.setFirewallStatefulRule(FirewallStatefulRuleStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }

                if (context.testExpression("serviceName", targetDepth)) {
                    pathComponent.setServiceName(StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
            } else if (xmlEvent.isEndElement()) {
                if (context.getCurrentDepth() < originalDepth) {
                    return pathComponent;
                }
            }
        }
    }

    private static PathComponentStaxUnmarshaller instance;

    public static PathComponentStaxUnmarshaller getInstance() {
        if (instance == null)
            instance = new PathComponentStaxUnmarshaller();
        return instance;
    }
}
