/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateCustomerGatewayRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateCustomerGatewayRequestMarshaller
implements Marshaller<Request<CreateCustomerGatewayRequest>, CreateCustomerGatewayRequest> {
    public Request<CreateCustomerGatewayRequest> marshall(CreateCustomerGatewayRequest createCustomerGatewayRequest) {
        SdkInternalList createCustomerGatewayRequestTagSpecificationsList;
        if (createCustomerGatewayRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createCustomerGatewayRequest, "AmazonEC2");
        request.addParameter("Action", "CreateCustomerGateway");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createCustomerGatewayRequest.getBgpAsn() != null) {
            request.addParameter("BgpAsn", StringUtils.fromInteger((Integer)createCustomerGatewayRequest.getBgpAsn()));
        }
        if (createCustomerGatewayRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)createCustomerGatewayRequest.getPublicIp()));
        }
        if (createCustomerGatewayRequest.getCertificateArn() != null) {
            request.addParameter("CertificateArn", StringUtils.fromString((String)createCustomerGatewayRequest.getCertificateArn()));
        }
        if (createCustomerGatewayRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createCustomerGatewayRequest.getType()));
        }
        if (!(createCustomerGatewayRequestTagSpecificationsList = (SdkInternalList)createCustomerGatewayRequest.getTagSpecifications()).isEmpty() || !createCustomerGatewayRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createCustomerGatewayRequestTagSpecificationsListValue : createCustomerGatewayRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createCustomerGatewayRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createCustomerGatewayRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createCustomerGatewayRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createCustomerGatewayRequest.getDeviceName() != null) {
            request.addParameter("DeviceName", StringUtils.fromString((String)createCustomerGatewayRequest.getDeviceName()));
        }
        if (createCustomerGatewayRequest.getIpAddress() != null) {
            request.addParameter("IpAddress", StringUtils.fromString((String)createCustomerGatewayRequest.getIpAddress()));
        }
        return request;
    }
}

