/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSnapshotTierStatusRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSnapshotTierStatusRequestMarshaller
implements Marshaller<Request<DescribeSnapshotTierStatusRequest>, DescribeSnapshotTierStatusRequest> {
    public Request<DescribeSnapshotTierStatusRequest> marshall(DescribeSnapshotTierStatusRequest describeSnapshotTierStatusRequest) {
        if (describeSnapshotTierStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotTierStatusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshotTierStatus");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeSnapshotTierStatusRequestFiltersList = (SdkInternalList)describeSnapshotTierStatusRequest.getFilters();
        if (!describeSnapshotTierStatusRequestFiltersList.isEmpty() || !describeSnapshotTierStatusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeSnapshotTierStatusRequestFiltersListValue : describeSnapshotTierStatusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeSnapshotTierStatusRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeSnapshotTierStatusRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeSnapshotTierStatusRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotTierStatusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSnapshotTierStatusRequest.getNextToken()));
        }
        if (describeSnapshotTierStatusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSnapshotTierStatusRequest.getMaxResults()));
        }
        return request;
    }
}

