/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.FpgaDeviceInfo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FpgaInfo
implements Serializable,
Cloneable {
    private SdkInternalList<FpgaDeviceInfo> fpgas;
    private Integer totalFpgaMemoryInMiB;

    public List<FpgaDeviceInfo> getFpgas() {
        if (this.fpgas == null) {
            this.fpgas = new SdkInternalList();
        }
        return this.fpgas;
    }

    public void setFpgas(Collection<FpgaDeviceInfo> fpgas) {
        if (fpgas == null) {
            this.fpgas = null;
            return;
        }
        this.fpgas = new SdkInternalList(fpgas);
    }

    public FpgaInfo withFpgas(FpgaDeviceInfo ... fpgas) {
        if (this.fpgas == null) {
            this.setFpgas((Collection<FpgaDeviceInfo>)new SdkInternalList(fpgas.length));
        }
        for (FpgaDeviceInfo ele : fpgas) {
            this.fpgas.add((Object)ele);
        }
        return this;
    }

    public FpgaInfo withFpgas(Collection<FpgaDeviceInfo> fpgas) {
        this.setFpgas(fpgas);
        return this;
    }

    public void setTotalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
        this.totalFpgaMemoryInMiB = totalFpgaMemoryInMiB;
    }

    public Integer getTotalFpgaMemoryInMiB() {
        return this.totalFpgaMemoryInMiB;
    }

    public FpgaInfo withTotalFpgaMemoryInMiB(Integer totalFpgaMemoryInMiB) {
        this.setTotalFpgaMemoryInMiB(totalFpgaMemoryInMiB);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFpgas() != null) {
            sb.append("Fpgas: ").append(this.getFpgas()).append(",");
        }
        if (this.getTotalFpgaMemoryInMiB() != null) {
            sb.append("TotalFpgaMemoryInMiB: ").append(this.getTotalFpgaMemoryInMiB());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FpgaInfo)) {
            return false;
        }
        FpgaInfo other = (FpgaInfo)obj;
        if (other.getFpgas() == null ^ this.getFpgas() == null) {
            return false;
        }
        if (other.getFpgas() != null && !other.getFpgas().equals(this.getFpgas())) {
            return false;
        }
        if (other.getTotalFpgaMemoryInMiB() == null ^ this.getTotalFpgaMemoryInMiB() == null) {
            return false;
        }
        return other.getTotalFpgaMemoryInMiB() == null || other.getTotalFpgaMemoryInMiB().equals(this.getTotalFpgaMemoryInMiB());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFpgas() == null ? 0 : this.getFpgas().hashCode());
        hashCode = 31 * hashCode + (this.getTotalFpgaMemoryInMiB() == null ? 0 : this.getTotalFpgaMemoryInMiB().hashCode());
        return hashCode;
    }

    public FpgaInfo clone() {
        try {
            return (FpgaInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

