/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.services.ec2.model.transform.CreateVerifiedAccessGroupRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateVerifiedAccessGroupRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateVerifiedAccessGroupRequest> {
    private String verifiedAccessInstanceId;
    private String description;
    private String policyDocument;
    private SdkInternalList<TagSpecification> tagSpecifications;
    private String clientToken;

    public void setVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
        this.verifiedAccessInstanceId = verifiedAccessInstanceId;
    }

    public String getVerifiedAccessInstanceId() {
        return this.verifiedAccessInstanceId;
    }

    public CreateVerifiedAccessGroupRequest withVerifiedAccessInstanceId(String verifiedAccessInstanceId) {
        this.setVerifiedAccessInstanceId(verifiedAccessInstanceId);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public CreateVerifiedAccessGroupRequest withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setPolicyDocument(String policyDocument) {
        this.policyDocument = policyDocument;
    }

    public String getPolicyDocument() {
        return this.policyDocument;
    }

    public CreateVerifiedAccessGroupRequest withPolicyDocument(String policyDocument) {
        this.setPolicyDocument(policyDocument);
        return this;
    }

    public List<TagSpecification> getTagSpecifications() {
        if (this.tagSpecifications == null) {
            this.tagSpecifications = new SdkInternalList();
        }
        return this.tagSpecifications;
    }

    public void setTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        if (tagSpecifications == null) {
            this.tagSpecifications = null;
            return;
        }
        this.tagSpecifications = new SdkInternalList(tagSpecifications);
    }

    public CreateVerifiedAccessGroupRequest withTagSpecifications(TagSpecification ... tagSpecifications) {
        if (this.tagSpecifications == null) {
            this.setTagSpecifications((Collection<TagSpecification>)new SdkInternalList(tagSpecifications.length));
        }
        for (TagSpecification ele : tagSpecifications) {
            this.tagSpecifications.add((Object)ele);
        }
        return this;
    }

    public CreateVerifiedAccessGroupRequest withTagSpecifications(Collection<TagSpecification> tagSpecifications) {
        this.setTagSpecifications(tagSpecifications);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public CreateVerifiedAccessGroupRequest withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    @Override
    public Request<CreateVerifiedAccessGroupRequest> getDryRunRequest() {
        Request<CreateVerifiedAccessGroupRequest> request = new CreateVerifiedAccessGroupRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVerifiedAccessInstanceId() != null) {
            sb.append("VerifiedAccessInstanceId: ").append(this.getVerifiedAccessInstanceId()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getPolicyDocument() != null) {
            sb.append("PolicyDocument: ").append(this.getPolicyDocument()).append(",");
        }
        if (this.getTagSpecifications() != null) {
            sb.append("TagSpecifications: ").append(this.getTagSpecifications()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateVerifiedAccessGroupRequest)) {
            return false;
        }
        CreateVerifiedAccessGroupRequest other = (CreateVerifiedAccessGroupRequest)obj;
        if (other.getVerifiedAccessInstanceId() == null ^ this.getVerifiedAccessInstanceId() == null) {
            return false;
        }
        if (other.getVerifiedAccessInstanceId() != null && !other.getVerifiedAccessInstanceId().equals(this.getVerifiedAccessInstanceId())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getPolicyDocument() == null ^ this.getPolicyDocument() == null) {
            return false;
        }
        if (other.getPolicyDocument() != null && !other.getPolicyDocument().equals(this.getPolicyDocument())) {
            return false;
        }
        if (other.getTagSpecifications() == null ^ this.getTagSpecifications() == null) {
            return false;
        }
        if (other.getTagSpecifications() != null && !other.getTagSpecifications().equals(this.getTagSpecifications())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        return other.getClientToken() == null || other.getClientToken().equals(this.getClientToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVerifiedAccessInstanceId() == null ? 0 : this.getVerifiedAccessInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getPolicyDocument() == null ? 0 : this.getPolicyDocument().hashCode());
        hashCode = 31 * hashCode + (this.getTagSpecifications() == null ? 0 : this.getTagSpecifications().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        return hashCode;
    }

    public CreateVerifiedAccessGroupRequest clone() {
        return (CreateVerifiedAccessGroupRequest)super.clone();
    }
}

