/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.RestoreSnapshotTierRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RestoreSnapshotTierRequestMarshaller
implements Marshaller<Request<RestoreSnapshotTierRequest>, RestoreSnapshotTierRequest> {
    public Request<RestoreSnapshotTierRequest> marshall(RestoreSnapshotTierRequest restoreSnapshotTierRequest) {
        if (restoreSnapshotTierRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)restoreSnapshotTierRequest, "AmazonEC2");
        request.addParameter("Action", "RestoreSnapshotTier");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (restoreSnapshotTierRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)restoreSnapshotTierRequest.getSnapshotId()));
        }
        if (restoreSnapshotTierRequest.getTemporaryRestoreDays() != null) {
            request.addParameter("TemporaryRestoreDays", StringUtils.fromInteger((Integer)restoreSnapshotTierRequest.getTemporaryRestoreDays()));
        }
        if (restoreSnapshotTierRequest.getPermanentRestore() != null) {
            request.addParameter("PermanentRestore", StringUtils.fromBoolean((Boolean)restoreSnapshotTierRequest.getPermanentRestore()));
        }
        return request;
    }
}

