/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateConfigRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateOverridesRequest;
import com.amazonaws.services.ec2.model.FleetLaunchTemplateSpecificationRequest;
import com.amazonaws.services.ec2.model.ModifyFleetRequest;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.TargetCapacitySpecificationRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyFleetRequestMarshaller
implements Marshaller<Request<ModifyFleetRequest>, ModifyFleetRequest> {
    public Request<ModifyFleetRequest> marshall(ModifyFleetRequest modifyFleetRequest) {
        TargetCapacitySpecificationRequest targetCapacitySpecification;
        SdkInternalList modifyFleetRequestLaunchTemplateConfigsList;
        if (modifyFleetRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyFleetRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyFleet");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyFleetRequest.getExcessCapacityTerminationPolicy() != null) {
            request.addParameter("ExcessCapacityTerminationPolicy", StringUtils.fromString((String)modifyFleetRequest.getExcessCapacityTerminationPolicy()));
        }
        if (!(modifyFleetRequestLaunchTemplateConfigsList = (SdkInternalList)modifyFleetRequest.getLaunchTemplateConfigs()).isEmpty() || !modifyFleetRequestLaunchTemplateConfigsList.isAutoConstruct()) {
            int launchTemplateConfigsListIndex = 1;
            for (FleetLaunchTemplateConfigRequest modifyFleetRequestLaunchTemplateConfigsListValue : modifyFleetRequestLaunchTemplateConfigsList) {
                SdkInternalList fleetLaunchTemplateConfigRequestOverridesList;
                FleetLaunchTemplateSpecificationRequest launchTemplateSpecification = modifyFleetRequestLaunchTemplateConfigsListValue.getLaunchTemplateSpecification();
                if (launchTemplateSpecification != null) {
                    if (launchTemplateSpecification.getLaunchTemplateId() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateId", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateId()));
                    }
                    if (launchTemplateSpecification.getLaunchTemplateName() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.LaunchTemplateName", StringUtils.fromString((String)launchTemplateSpecification.getLaunchTemplateName()));
                    }
                    if (launchTemplateSpecification.getVersion() != null) {
                        request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".LaunchTemplateSpecification.Version", StringUtils.fromString((String)launchTemplateSpecification.getVersion()));
                    }
                }
                if (!(fleetLaunchTemplateConfigRequestOverridesList = (SdkInternalList)modifyFleetRequestLaunchTemplateConfigsListValue.getOverrides()).isEmpty() || !fleetLaunchTemplateConfigRequestOverridesList.isAutoConstruct()) {
                    int overridesListIndex = 1;
                    for (FleetLaunchTemplateOverridesRequest fleetLaunchTemplateConfigRequestOverridesListValue : fleetLaunchTemplateConfigRequestOverridesList) {
                        Placement placement;
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".InstanceType", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getInstanceType()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".MaxPrice", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getMaxPrice()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".SubnetId", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getSubnetId()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".AvailabilityZone", StringUtils.fromString((String)fleetLaunchTemplateConfigRequestOverridesListValue.getAvailabilityZone()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".WeightedCapacity", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getWeightedCapacity()));
                        }
                        if (fleetLaunchTemplateConfigRequestOverridesListValue.getPriority() != null) {
                            request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Priority", StringUtils.fromDouble((Double)fleetLaunchTemplateConfigRequestOverridesListValue.getPriority()));
                        }
                        if ((placement = fleetLaunchTemplateConfigRequestOverridesListValue.getPlacement()) != null) {
                            if (placement.getAvailabilityZone() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                            }
                            if (placement.getAffinity() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Affinity", StringUtils.fromString((String)placement.getAffinity()));
                            }
                            if (placement.getGroupName() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                            }
                            if (placement.getPartitionNumber() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.PartitionNumber", StringUtils.fromInteger((Integer)placement.getPartitionNumber()));
                            }
                            if (placement.getHostId() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostId", StringUtils.fromString((String)placement.getHostId()));
                            }
                            if (placement.getTenancy() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.Tenancy", StringUtils.fromString((String)placement.getTenancy()));
                            }
                            if (placement.getSpreadDomain() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.SpreadDomain", StringUtils.fromString((String)placement.getSpreadDomain()));
                            }
                            if (placement.getHostResourceGroupArn() != null) {
                                request.addParameter("LaunchTemplateConfig." + launchTemplateConfigsListIndex + ".Overrides." + overridesListIndex + ".Placement.HostResourceGroupArn", StringUtils.fromString((String)placement.getHostResourceGroupArn()));
                            }
                        }
                        ++overridesListIndex;
                    }
                }
                ++launchTemplateConfigsListIndex;
            }
        }
        if (modifyFleetRequest.getFleetId() != null) {
            request.addParameter("FleetId", StringUtils.fromString((String)modifyFleetRequest.getFleetId()));
        }
        if ((targetCapacitySpecification = modifyFleetRequest.getTargetCapacitySpecification()) != null) {
            if (targetCapacitySpecification.getTotalTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.TotalTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getTotalTargetCapacity()));
            }
            if (targetCapacitySpecification.getOnDemandTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.OnDemandTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getOnDemandTargetCapacity()));
            }
            if (targetCapacitySpecification.getSpotTargetCapacity() != null) {
                request.addParameter("TargetCapacitySpecification.SpotTargetCapacity", StringUtils.fromInteger((Integer)targetCapacitySpecification.getSpotTargetCapacity()));
            }
            if (targetCapacitySpecification.getDefaultTargetCapacityType() != null) {
                request.addParameter("TargetCapacitySpecification.DefaultTargetCapacityType", StringUtils.fromString((String)targetCapacitySpecification.getDefaultTargetCapacityType()));
            }
        }
        if (modifyFleetRequest.getContext() != null) {
            request.addParameter("Context", StringUtils.fromString((String)modifyFleetRequest.getContext()));
        }
        return request;
    }
}

