/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeVpcEndpointServicesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeVpcEndpointServicesRequestMarshaller
implements Marshaller<Request<DescribeVpcEndpointServicesRequest>, DescribeVpcEndpointServicesRequest> {
    public Request<DescribeVpcEndpointServicesRequest> marshall(DescribeVpcEndpointServicesRequest describeVpcEndpointServicesRequest) {
        SdkInternalList describeVpcEndpointServicesRequestFiltersList;
        if (describeVpcEndpointServicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeVpcEndpointServicesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeVpcEndpointServices");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeVpcEndpointServicesRequestServiceNamesList = (SdkInternalList)describeVpcEndpointServicesRequest.getServiceNames();
        if (!describeVpcEndpointServicesRequestServiceNamesList.isEmpty() || !describeVpcEndpointServicesRequestServiceNamesList.isAutoConstruct()) {
            int serviceNamesListIndex = 1;
            for (String describeVpcEndpointServicesRequestServiceNamesListValue : describeVpcEndpointServicesRequestServiceNamesList) {
                if (describeVpcEndpointServicesRequestServiceNamesListValue != null) {
                    request.addParameter("ServiceName." + serviceNamesListIndex, StringUtils.fromString((String)describeVpcEndpointServicesRequestServiceNamesListValue));
                }
                ++serviceNamesListIndex;
            }
        }
        if (!(describeVpcEndpointServicesRequestFiltersList = (SdkInternalList)describeVpcEndpointServicesRequest.getFilters()).isEmpty() || !describeVpcEndpointServicesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeVpcEndpointServicesRequestFiltersListValue : describeVpcEndpointServicesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeVpcEndpointServicesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeVpcEndpointServicesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeVpcEndpointServicesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeVpcEndpointServicesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeVpcEndpointServicesRequest.getMaxResults()));
        }
        if (describeVpcEndpointServicesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeVpcEndpointServicesRequest.getNextToken()));
        }
        return request;
    }
}

