/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifySubnetAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifySubnetAttributeRequestMarshaller
implements Marshaller<Request<ModifySubnetAttributeRequest>, ModifySubnetAttributeRequest> {
    public Request<ModifySubnetAttributeRequest> marshall(ModifySubnetAttributeRequest modifySubnetAttributeRequest) {
        if (modifySubnetAttributeRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySubnetAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySubnetAttribute");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifySubnetAttributeRequest.getAssignIpv6AddressOnCreation() != null) {
            request.addParameter("AssignIpv6AddressOnCreation.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getAssignIpv6AddressOnCreation()));
        }
        if (modifySubnetAttributeRequest.getMapPublicIpOnLaunch() != null) {
            request.addParameter("MapPublicIpOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getMapPublicIpOnLaunch()));
        }
        if (modifySubnetAttributeRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)modifySubnetAttributeRequest.getSubnetId()));
        }
        if (modifySubnetAttributeRequest.getMapCustomerOwnedIpOnLaunch() != null) {
            request.addParameter("MapCustomerOwnedIpOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getMapCustomerOwnedIpOnLaunch()));
        }
        if (modifySubnetAttributeRequest.getCustomerOwnedIpv4Pool() != null) {
            request.addParameter("CustomerOwnedIpv4Pool", StringUtils.fromString((String)modifySubnetAttributeRequest.getCustomerOwnedIpv4Pool()));
        }
        if (modifySubnetAttributeRequest.getEnableDns64() != null) {
            request.addParameter("EnableDns64.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getEnableDns64()));
        }
        if (modifySubnetAttributeRequest.getPrivateDnsHostnameTypeOnLaunch() != null) {
            request.addParameter("PrivateDnsHostnameTypeOnLaunch", StringUtils.fromString((String)modifySubnetAttributeRequest.getPrivateDnsHostnameTypeOnLaunch()));
        }
        if (modifySubnetAttributeRequest.getEnableResourceNameDnsARecordOnLaunch() != null) {
            request.addParameter("EnableResourceNameDnsARecordOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getEnableResourceNameDnsARecordOnLaunch()));
        }
        if (modifySubnetAttributeRequest.getEnableResourceNameDnsAAAARecordOnLaunch() != null) {
            request.addParameter("EnableResourceNameDnsAAAARecordOnLaunch.Value", StringUtils.fromBoolean((Boolean)modifySubnetAttributeRequest.getEnableResourceNameDnsAAAARecordOnLaunch()));
        }
        return request;
    }
}

