/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AllocationState;
import com.amazonaws.services.ec2.model.AllowsMultipleInstanceTypes;
import com.amazonaws.services.ec2.model.AutoPlacement;
import com.amazonaws.services.ec2.model.AvailableCapacity;
import com.amazonaws.services.ec2.model.HostInstance;
import com.amazonaws.services.ec2.model.HostProperties;
import com.amazonaws.services.ec2.model.HostRecovery;
import com.amazonaws.services.ec2.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Host
implements Serializable,
Cloneable {
    private String autoPlacement;
    private String availabilityZone;
    private AvailableCapacity availableCapacity;
    private String clientToken;
    private String hostId;
    private HostProperties hostProperties;
    private String hostReservationId;
    private SdkInternalList<HostInstance> instances;
    private String state;
    private Date allocationTime;
    private Date releaseTime;
    private SdkInternalList<Tag> tags;
    private String hostRecovery;
    private String allowsMultipleInstanceTypes;
    private String ownerId;
    private String availabilityZoneId;
    private Boolean memberOfServiceLinkedResourceGroup;

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public Host withAutoPlacement(String autoPlacement) {
        this.setAutoPlacement(autoPlacement);
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.withAutoPlacement(autoPlacement);
    }

    public Host withAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Host withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setAvailableCapacity(AvailableCapacity availableCapacity) {
        this.availableCapacity = availableCapacity;
    }

    public AvailableCapacity getAvailableCapacity() {
        return this.availableCapacity;
    }

    public Host withAvailableCapacity(AvailableCapacity availableCapacity) {
        this.setAvailableCapacity(availableCapacity);
        return this;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public String getClientToken() {
        return this.clientToken;
    }

    public Host withClientToken(String clientToken) {
        this.setClientToken(clientToken);
        return this;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getHostId() {
        return this.hostId;
    }

    public Host withHostId(String hostId) {
        this.setHostId(hostId);
        return this;
    }

    public void setHostProperties(HostProperties hostProperties) {
        this.hostProperties = hostProperties;
    }

    public HostProperties getHostProperties() {
        return this.hostProperties;
    }

    public Host withHostProperties(HostProperties hostProperties) {
        this.setHostProperties(hostProperties);
        return this;
    }

    public void setHostReservationId(String hostReservationId) {
        this.hostReservationId = hostReservationId;
    }

    public String getHostReservationId() {
        return this.hostReservationId;
    }

    public Host withHostReservationId(String hostReservationId) {
        this.setHostReservationId(hostReservationId);
        return this;
    }

    public List<HostInstance> getInstances() {
        if (this.instances == null) {
            this.instances = new SdkInternalList();
        }
        return this.instances;
    }

    public void setInstances(Collection<HostInstance> instances) {
        if (instances == null) {
            this.instances = null;
            return;
        }
        this.instances = new SdkInternalList(instances);
    }

    public Host withInstances(HostInstance ... instances) {
        if (this.instances == null) {
            this.setInstances((Collection<HostInstance>)new SdkInternalList(instances.length));
        }
        for (HostInstance ele : instances) {
            this.instances.add((Object)ele);
        }
        return this;
    }

    public Host withInstances(Collection<HostInstance> instances) {
        this.setInstances(instances);
        return this;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getState() {
        return this.state;
    }

    public Host withState(String state) {
        this.setState(state);
        return this;
    }

    public void setState(AllocationState state) {
        this.withState(state);
    }

    public Host withState(AllocationState state) {
        this.state = state.toString();
        return this;
    }

    public void setAllocationTime(Date allocationTime) {
        this.allocationTime = allocationTime;
    }

    public Date getAllocationTime() {
        return this.allocationTime;
    }

    public Host withAllocationTime(Date allocationTime) {
        this.setAllocationTime(allocationTime);
        return this;
    }

    public void setReleaseTime(Date releaseTime) {
        this.releaseTime = releaseTime;
    }

    public Date getReleaseTime() {
        return this.releaseTime;
    }

    public Host withReleaseTime(Date releaseTime) {
        this.setReleaseTime(releaseTime);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Host withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Host withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setHostRecovery(String hostRecovery) {
        this.hostRecovery = hostRecovery;
    }

    public String getHostRecovery() {
        return this.hostRecovery;
    }

    public Host withHostRecovery(String hostRecovery) {
        this.setHostRecovery(hostRecovery);
        return this;
    }

    public void setHostRecovery(HostRecovery hostRecovery) {
        this.withHostRecovery(hostRecovery);
    }

    public Host withHostRecovery(HostRecovery hostRecovery) {
        this.hostRecovery = hostRecovery.toString();
        return this;
    }

    public void setAllowsMultipleInstanceTypes(String allowsMultipleInstanceTypes) {
        this.allowsMultipleInstanceTypes = allowsMultipleInstanceTypes;
    }

    public String getAllowsMultipleInstanceTypes() {
        return this.allowsMultipleInstanceTypes;
    }

    public Host withAllowsMultipleInstanceTypes(String allowsMultipleInstanceTypes) {
        this.setAllowsMultipleInstanceTypes(allowsMultipleInstanceTypes);
        return this;
    }

    public void setAllowsMultipleInstanceTypes(AllowsMultipleInstanceTypes allowsMultipleInstanceTypes) {
        this.withAllowsMultipleInstanceTypes(allowsMultipleInstanceTypes);
    }

    public Host withAllowsMultipleInstanceTypes(AllowsMultipleInstanceTypes allowsMultipleInstanceTypes) {
        this.allowsMultipleInstanceTypes = allowsMultipleInstanceTypes.toString();
        return this;
    }

    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public Host withOwnerId(String ownerId) {
        this.setOwnerId(ownerId);
        return this;
    }

    public void setAvailabilityZoneId(String availabilityZoneId) {
        this.availabilityZoneId = availabilityZoneId;
    }

    public String getAvailabilityZoneId() {
        return this.availabilityZoneId;
    }

    public Host withAvailabilityZoneId(String availabilityZoneId) {
        this.setAvailabilityZoneId(availabilityZoneId);
        return this;
    }

    public void setMemberOfServiceLinkedResourceGroup(Boolean memberOfServiceLinkedResourceGroup) {
        this.memberOfServiceLinkedResourceGroup = memberOfServiceLinkedResourceGroup;
    }

    public Boolean getMemberOfServiceLinkedResourceGroup() {
        return this.memberOfServiceLinkedResourceGroup;
    }

    public Host withMemberOfServiceLinkedResourceGroup(Boolean memberOfServiceLinkedResourceGroup) {
        this.setMemberOfServiceLinkedResourceGroup(memberOfServiceLinkedResourceGroup);
        return this;
    }

    public Boolean isMemberOfServiceLinkedResourceGroup() {
        return this.memberOfServiceLinkedResourceGroup;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: ").append(this.getAutoPlacement()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getAvailableCapacity() != null) {
            sb.append("AvailableCapacity: ").append(this.getAvailableCapacity()).append(",");
        }
        if (this.getClientToken() != null) {
            sb.append("ClientToken: ").append(this.getClientToken()).append(",");
        }
        if (this.getHostId() != null) {
            sb.append("HostId: ").append(this.getHostId()).append(",");
        }
        if (this.getHostProperties() != null) {
            sb.append("HostProperties: ").append(this.getHostProperties()).append(",");
        }
        if (this.getHostReservationId() != null) {
            sb.append("HostReservationId: ").append(this.getHostReservationId()).append(",");
        }
        if (this.getInstances() != null) {
            sb.append("Instances: ").append(this.getInstances()).append(",");
        }
        if (this.getState() != null) {
            sb.append("State: ").append(this.getState()).append(",");
        }
        if (this.getAllocationTime() != null) {
            sb.append("AllocationTime: ").append(this.getAllocationTime()).append(",");
        }
        if (this.getReleaseTime() != null) {
            sb.append("ReleaseTime: ").append(this.getReleaseTime()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getHostRecovery() != null) {
            sb.append("HostRecovery: ").append(this.getHostRecovery()).append(",");
        }
        if (this.getAllowsMultipleInstanceTypes() != null) {
            sb.append("AllowsMultipleInstanceTypes: ").append(this.getAllowsMultipleInstanceTypes()).append(",");
        }
        if (this.getOwnerId() != null) {
            sb.append("OwnerId: ").append(this.getOwnerId()).append(",");
        }
        if (this.getAvailabilityZoneId() != null) {
            sb.append("AvailabilityZoneId: ").append(this.getAvailabilityZoneId()).append(",");
        }
        if (this.getMemberOfServiceLinkedResourceGroup() != null) {
            sb.append("MemberOfServiceLinkedResourceGroup: ").append(this.getMemberOfServiceLinkedResourceGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Host)) {
            return false;
        }
        Host other = (Host)obj;
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        if (other.getAutoPlacement() != null && !other.getAutoPlacement().equals(this.getAutoPlacement())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getAvailableCapacity() == null ^ this.getAvailableCapacity() == null) {
            return false;
        }
        if (other.getAvailableCapacity() != null && !other.getAvailableCapacity().equals(this.getAvailableCapacity())) {
            return false;
        }
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getHostId() == null ^ this.getHostId() == null) {
            return false;
        }
        if (other.getHostId() != null && !other.getHostId().equals(this.getHostId())) {
            return false;
        }
        if (other.getHostProperties() == null ^ this.getHostProperties() == null) {
            return false;
        }
        if (other.getHostProperties() != null && !other.getHostProperties().equals(this.getHostProperties())) {
            return false;
        }
        if (other.getHostReservationId() == null ^ this.getHostReservationId() == null) {
            return false;
        }
        if (other.getHostReservationId() != null && !other.getHostReservationId().equals(this.getHostReservationId())) {
            return false;
        }
        if (other.getInstances() == null ^ this.getInstances() == null) {
            return false;
        }
        if (other.getInstances() != null && !other.getInstances().equals(this.getInstances())) {
            return false;
        }
        if (other.getState() == null ^ this.getState() == null) {
            return false;
        }
        if (other.getState() != null && !other.getState().equals(this.getState())) {
            return false;
        }
        if (other.getAllocationTime() == null ^ this.getAllocationTime() == null) {
            return false;
        }
        if (other.getAllocationTime() != null && !other.getAllocationTime().equals(this.getAllocationTime())) {
            return false;
        }
        if (other.getReleaseTime() == null ^ this.getReleaseTime() == null) {
            return false;
        }
        if (other.getReleaseTime() != null && !other.getReleaseTime().equals(this.getReleaseTime())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getHostRecovery() == null ^ this.getHostRecovery() == null) {
            return false;
        }
        if (other.getHostRecovery() != null && !other.getHostRecovery().equals(this.getHostRecovery())) {
            return false;
        }
        if (other.getAllowsMultipleInstanceTypes() == null ^ this.getAllowsMultipleInstanceTypes() == null) {
            return false;
        }
        if (other.getAllowsMultipleInstanceTypes() != null && !other.getAllowsMultipleInstanceTypes().equals(this.getAllowsMultipleInstanceTypes())) {
            return false;
        }
        if (other.getOwnerId() == null ^ this.getOwnerId() == null) {
            return false;
        }
        if (other.getOwnerId() != null && !other.getOwnerId().equals(this.getOwnerId())) {
            return false;
        }
        if (other.getAvailabilityZoneId() == null ^ this.getAvailabilityZoneId() == null) {
            return false;
        }
        if (other.getAvailabilityZoneId() != null && !other.getAvailabilityZoneId().equals(this.getAvailabilityZoneId())) {
            return false;
        }
        if (other.getMemberOfServiceLinkedResourceGroup() == null ^ this.getMemberOfServiceLinkedResourceGroup() == null) {
            return false;
        }
        return other.getMemberOfServiceLinkedResourceGroup() == null || other.getMemberOfServiceLinkedResourceGroup().equals(this.getMemberOfServiceLinkedResourceGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getAvailableCapacity() == null ? 0 : this.getAvailableCapacity().hashCode());
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getHostId() == null ? 0 : this.getHostId().hashCode());
        hashCode = 31 * hashCode + (this.getHostProperties() == null ? 0 : this.getHostProperties().hashCode());
        hashCode = 31 * hashCode + (this.getHostReservationId() == null ? 0 : this.getHostReservationId().hashCode());
        hashCode = 31 * hashCode + (this.getInstances() == null ? 0 : this.getInstances().hashCode());
        hashCode = 31 * hashCode + (this.getState() == null ? 0 : this.getState().hashCode());
        hashCode = 31 * hashCode + (this.getAllocationTime() == null ? 0 : this.getAllocationTime().hashCode());
        hashCode = 31 * hashCode + (this.getReleaseTime() == null ? 0 : this.getReleaseTime().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getHostRecovery() == null ? 0 : this.getHostRecovery().hashCode());
        hashCode = 31 * hashCode + (this.getAllowsMultipleInstanceTypes() == null ? 0 : this.getAllowsMultipleInstanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.getOwnerId() == null ? 0 : this.getOwnerId().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZoneId() == null ? 0 : this.getAvailabilityZoneId().hashCode());
        hashCode = 31 * hashCode + (this.getMemberOfServiceLinkedResourceGroup() == null ? 0 : this.getMemberOfServiceLinkedResourceGroup().hashCode());
        return hashCode;
    }

    public Host clone() {
        try {
            return (Host)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

