/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.SearchTransitGatewayRoutesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class SearchTransitGatewayRoutesRequestMarshaller
implements Marshaller<Request<SearchTransitGatewayRoutesRequest>, SearchTransitGatewayRoutesRequest> {
    public Request<SearchTransitGatewayRoutesRequest> marshall(SearchTransitGatewayRoutesRequest searchTransitGatewayRoutesRequest) {
        SdkInternalList searchTransitGatewayRoutesRequestFiltersList;
        if (searchTransitGatewayRoutesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)searchTransitGatewayRoutesRequest, "AmazonEC2");
        request.addParameter("Action", "SearchTransitGatewayRoutes");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (searchTransitGatewayRoutesRequest.getTransitGatewayRouteTableId() != null) {
            request.addParameter("TransitGatewayRouteTableId", StringUtils.fromString((String)searchTransitGatewayRoutesRequest.getTransitGatewayRouteTableId()));
        }
        if (!(searchTransitGatewayRoutesRequestFiltersList = (SdkInternalList)searchTransitGatewayRoutesRequest.getFilters()).isEmpty() || !searchTransitGatewayRoutesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter searchTransitGatewayRoutesRequestFiltersListValue : searchTransitGatewayRoutesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (searchTransitGatewayRoutesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)searchTransitGatewayRoutesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)searchTransitGatewayRoutesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (searchTransitGatewayRoutesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)searchTransitGatewayRoutesRequest.getMaxResults()));
        }
        return request;
    }
}

