/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeInstanceStatusRequestMarshaller
implements Marshaller<Request<DescribeInstanceStatusRequest>, DescribeInstanceStatusRequest> {
    public Request<DescribeInstanceStatusRequest> marshall(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        SdkInternalList describeInstanceStatusRequestFiltersList;
        if (describeInstanceStatusRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeInstanceStatusRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeInstanceStatus");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeInstanceStatusRequestInstanceIdsList = (SdkInternalList)describeInstanceStatusRequest.getInstanceIds();
        if (!describeInstanceStatusRequestInstanceIdsList.isEmpty() || !describeInstanceStatusRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String describeInstanceStatusRequestInstanceIdsListValue : describeInstanceStatusRequestInstanceIdsList) {
                if (describeInstanceStatusRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)describeInstanceStatusRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        if (!(describeInstanceStatusRequestFiltersList = (SdkInternalList)describeInstanceStatusRequest.getFilters()).isEmpty() || !describeInstanceStatusRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeInstanceStatusRequestFiltersListValue : describeInstanceStatusRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeInstanceStatusRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeInstanceStatusRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeInstanceStatusRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeInstanceStatusRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeInstanceStatusRequest.getNextToken()));
        }
        if (describeInstanceStatusRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeInstanceStatusRequest.getMaxResults()));
        }
        if (describeInstanceStatusRequest.getIncludeAllInstances() != null) {
            request.addParameter("IncludeAllInstances", StringUtils.fromBoolean((Boolean)describeInstanceStatusRequest.getIncludeAllInstances()));
        }
        return request;
    }
}

