/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AttachVolumeRequestMarshaller
implements Marshaller<Request<AttachVolumeRequest>, AttachVolumeRequest> {
    public Request<AttachVolumeRequest> marshall(AttachVolumeRequest attachVolumeRequest) {
        if (attachVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)attachVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "AttachVolume");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (attachVolumeRequest.getVolumeId() != null) {
            request.addParameter("VolumeId", StringUtils.fromString((String)attachVolumeRequest.getVolumeId()));
        }
        if (attachVolumeRequest.getInstanceId() != null) {
            request.addParameter("InstanceId", StringUtils.fromString((String)attachVolumeRequest.getInstanceId()));
        }
        if (attachVolumeRequest.getDevice() != null) {
            request.addParameter("Device", StringUtils.fromString((String)attachVolumeRequest.getDevice()));
        }
        return request;
    }
}

