/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateVpnConnectionRequest;
import com.amazonaws.services.ec2.model.VpnConnectionOptionsSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpnConnectionRequestMarshaller
implements Marshaller<Request<CreateVpnConnectionRequest>, CreateVpnConnectionRequest> {
    public Request<CreateVpnConnectionRequest> marshall(CreateVpnConnectionRequest createVpnConnectionRequest) {
        VpnConnectionOptionsSpecification options;
        if (createVpnConnectionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpnConnectionRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpnConnection");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpnConnectionRequest.getType() != null) {
            request.addParameter("Type", StringUtils.fromString((String)createVpnConnectionRequest.getType()));
        }
        if (createVpnConnectionRequest.getCustomerGatewayId() != null) {
            request.addParameter("CustomerGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.getCustomerGatewayId()));
        }
        if (createVpnConnectionRequest.getVpnGatewayId() != null) {
            request.addParameter("VpnGatewayId", StringUtils.fromString((String)createVpnConnectionRequest.getVpnGatewayId()));
        }
        if ((options = createVpnConnectionRequest.getOptions()) != null && options.getStaticRoutesOnly() != null) {
            request.addParameter("Options.StaticRoutesOnly", StringUtils.fromBoolean((Boolean)options.getStaticRoutesOnly()));
        }
        return request;
    }
}

