/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFlowLogsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFlowLogsRequestMarshaller
implements Marshaller<Request<DescribeFlowLogsRequest>, DescribeFlowLogsRequest> {
    public Request<DescribeFlowLogsRequest> marshall(DescribeFlowLogsRequest describeFlowLogsRequest) {
        SdkInternalList describeFlowLogsRequestFilterList;
        if (describeFlowLogsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFlowLogsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFlowLogs");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeFlowLogsRequestFlowLogIdsList = (SdkInternalList)describeFlowLogsRequest.getFlowLogIds();
        if (!describeFlowLogsRequestFlowLogIdsList.isEmpty() || !describeFlowLogsRequestFlowLogIdsList.isAutoConstruct()) {
            int flowLogIdsListIndex = 1;
            for (String describeFlowLogsRequestFlowLogIdsListValue : describeFlowLogsRequestFlowLogIdsList) {
                if (describeFlowLogsRequestFlowLogIdsListValue != null) {
                    request.addParameter("FlowLogId." + flowLogIdsListIndex, StringUtils.fromString((String)describeFlowLogsRequestFlowLogIdsListValue));
                }
                ++flowLogIdsListIndex;
            }
        }
        if (!(describeFlowLogsRequestFilterList = (SdkInternalList)describeFlowLogsRequest.getFilter()).isEmpty() || !describeFlowLogsRequestFilterList.isAutoConstruct()) {
            int filterListIndex = 1;
            for (Filter describeFlowLogsRequestFilterListValue : describeFlowLogsRequestFilterList) {
                SdkInternalList filterValuesList;
                if (describeFlowLogsRequestFilterListValue.getName() != null) {
                    request.addParameter("Filter." + filterListIndex + ".Name", StringUtils.fromString((String)describeFlowLogsRequestFilterListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFlowLogsRequestFilterListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filterListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filterListIndex;
            }
        }
        if (describeFlowLogsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFlowLogsRequest.getNextToken()));
        }
        if (describeFlowLogsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFlowLogsRequest.getMaxResults()));
        }
        return request;
    }
}

