/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyVpcAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyVpcAttributeRequestMarshaller
implements Marshaller<Request<ModifyVpcAttributeRequest>, ModifyVpcAttributeRequest> {
    public Request<ModifyVpcAttributeRequest> marshall(ModifyVpcAttributeRequest modifyVpcAttributeRequest) {
        if (modifyVpcAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyVpcAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyVpcAttribute");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyVpcAttributeRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString((String)modifyVpcAttributeRequest.getVpcId()));
        }
        if (modifyVpcAttributeRequest.getEnableDnsSupport() != null) {
            request.addParameter("EnableDnsSupport.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.getEnableDnsSupport()));
        }
        if (modifyVpcAttributeRequest.getEnableDnsHostnames() != null) {
            request.addParameter("EnableDnsHostnames.Value", StringUtils.fromBoolean((Boolean)modifyVpcAttributeRequest.getEnableDnsHostnames()));
        }
        return request;
    }
}

