/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SpotOptions;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SpotOptionsStaxUnmarshaller
implements Unmarshaller<SpotOptions, StaxUnmarshallerContext> {
    private static SpotOptionsStaxUnmarshaller instance;

    public SpotOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        SpotOptions spotOptions = new SpotOptions();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return spotOptions;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("allocationStrategy", targetDepth)) {
                    spotOptions.setAllocationStrategy(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("instanceInterruptionBehavior", targetDepth)) {
                    spotOptions.setInstanceInterruptionBehavior(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("instancePoolsToUseCount", targetDepth)) continue;
                spotOptions.setInstancePoolsToUseCount(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return spotOptions;
    }

    public static SpotOptionsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SpotOptionsStaxUnmarshaller();
        }
        return instance;
    }
}

