/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.GatewayType;
import com.amazonaws.services.ec2.model.transform.CreateCustomerGatewayRequestMarshaller;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;

public class CreateCustomerGatewayRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<CreateCustomerGatewayRequest> {
    private String type;
    private String publicIp;
    private Integer bgpAsn;

    public CreateCustomerGatewayRequest() {
    }

    public CreateCustomerGatewayRequest(String type, String publicIp, Integer bgpAsn) {
        this.setType(type);
        this.setPublicIp(publicIp);
        this.setBgpAsn(bgpAsn);
    }

    public CreateCustomerGatewayRequest(GatewayType type, String publicIp, Integer bgpAsn) {
        this.setType(type.toString());
        this.setPublicIp(publicIp);
        this.setBgpAsn(bgpAsn);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public CreateCustomerGatewayRequest withType(String type) {
        this.setType(type);
        return this;
    }

    @JsonIgnore
    public void setType(GatewayType type) {
        this.type = type.toString();
    }

    public CreateCustomerGatewayRequest withType(GatewayType type) {
        this.setType(type);
        return this;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public CreateCustomerGatewayRequest withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    public void setBgpAsn(Integer bgpAsn) {
        this.bgpAsn = bgpAsn;
    }

    public Integer getBgpAsn() {
        return this.bgpAsn;
    }

    public CreateCustomerGatewayRequest withBgpAsn(Integer bgpAsn) {
        this.setBgpAsn(bgpAsn);
        return this;
    }

    @Override
    public Request<CreateCustomerGatewayRequest> getDryRunRequest() {
        Request<CreateCustomerGatewayRequest> request = new CreateCustomerGatewayRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: ").append(this.getPublicIp()).append(",");
        }
        if (this.getBgpAsn() != null) {
            sb.append("BgpAsn: ").append(this.getBgpAsn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCustomerGatewayRequest)) {
            return false;
        }
        CreateCustomerGatewayRequest other = (CreateCustomerGatewayRequest)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getBgpAsn() == null ^ this.getBgpAsn() == null) {
            return false;
        }
        return other.getBgpAsn() == null || other.getBgpAsn().equals(this.getBgpAsn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getBgpAsn() == null ? 0 : this.getBgpAsn().hashCode());
        return hashCode;
    }

    public CreateCustomerGatewayRequest clone() {
        return (CreateCustomerGatewayRequest)super.clone();
    }
}

