/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.LaunchPermission;
import com.amazonaws.services.ec2.model.LaunchPermissionModifications;
import com.amazonaws.services.ec2.model.ModifyImageAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyImageAttributeRequestMarshaller
implements Marshaller<Request<ModifyImageAttributeRequest>, ModifyImageAttributeRequest> {
    public Request<ModifyImageAttributeRequest> marshall(ModifyImageAttributeRequest modifyImageAttributeRequest) {
        LaunchPermissionModifications launchPermission;
        SdkInternalList productCodesList;
        SdkInternalList userGroupsList;
        SdkInternalList userIdsList;
        if (modifyImageAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyImageAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyImageAttribute");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyImageAttributeRequest.getImageId() != null) {
            request.addParameter("ImageId", StringUtils.fromString((String)modifyImageAttributeRequest.getImageId()));
        }
        if (modifyImageAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifyImageAttributeRequest.getAttribute()));
        }
        if (modifyImageAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifyImageAttributeRequest.getOperationType()));
        }
        if (!(userIdsList = (SdkInternalList)modifyImageAttributeRequest.getUserIds()).isEmpty() || !userIdsList.isAutoConstruct()) {
            int userIdsListIndex = 1;
            for (Object userIdsListValue : userIdsList) {
                if (userIdsListValue != null) {
                    request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)userIdsListValue));
                }
                ++userIdsListIndex;
            }
        }
        if (!(userGroupsList = (SdkInternalList)modifyImageAttributeRequest.getUserGroups()).isEmpty() || !userGroupsList.isAutoConstruct()) {
            int userGroupsListIndex = 1;
            for (Object userGroupsListValue : userGroupsList) {
                if (userGroupsListValue != null) {
                    request.addParameter("UserGroup." + userGroupsListIndex, StringUtils.fromString((String)userGroupsListValue));
                }
                ++userGroupsListIndex;
            }
        }
        if (!(productCodesList = (SdkInternalList)modifyImageAttributeRequest.getProductCodes()).isEmpty() || !productCodesList.isAutoConstruct()) {
            int productCodesListIndex = 1;
            for (String productCodesListValue : productCodesList) {
                if (productCodesListValue != null) {
                    request.addParameter("ProductCode." + productCodesListIndex, StringUtils.fromString((String)productCodesListValue));
                }
                ++productCodesListIndex;
            }
        }
        if (modifyImageAttributeRequest.getValue() != null) {
            request.addParameter("Value", StringUtils.fromString((String)modifyImageAttributeRequest.getValue()));
        }
        if ((launchPermission = modifyImageAttributeRequest.getLaunchPermission()) != null) {
            SdkInternalList removeList;
            SdkInternalList addList = (SdkInternalList)launchPermission.getAdd();
            if (!addList.isEmpty() || !addList.isAutoConstruct()) {
                int addListIndex = 1;
                for (LaunchPermission addListValue : addList) {
                    if (addListValue.getUserId() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)addListValue.getUserId()));
                    }
                    if (addListValue.getGroup() != null) {
                        request.addParameter("LaunchPermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)addListValue.getGroup()));
                    }
                    ++addListIndex;
                }
            }
            if (!(removeList = (SdkInternalList)launchPermission.getRemove()).isEmpty() || !removeList.isAutoConstruct()) {
                int removeListIndex = 1;
                for (LaunchPermission removeListValue : removeList) {
                    if (removeListValue.getUserId() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)removeListValue.getUserId()));
                    }
                    if (removeListValue.getGroup() != null) {
                        request.addParameter("LaunchPermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)removeListValue.getGroup()));
                    }
                    ++removeListIndex;
                }
            }
        }
        if (modifyImageAttributeRequest.getDescription() != null) {
            request.addParameter("Description.Value", StringUtils.fromString((String)modifyImageAttributeRequest.getDescription()));
        }
        return request;
    }
}

