/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSnapshotsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSnapshotsRequestMarshaller
implements Marshaller<Request<DescribeSnapshotsRequest>, DescribeSnapshotsRequest> {
    public Request<DescribeSnapshotsRequest> marshall(DescribeSnapshotsRequest describeSnapshotsRequest) {
        SdkInternalList filtersList;
        SdkInternalList restorableByUserIdsList;
        SdkInternalList ownerIdsList;
        if (describeSnapshotsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSnapshotsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSnapshots");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList snapshotIdsList = (SdkInternalList)describeSnapshotsRequest.getSnapshotIds();
        if (!snapshotIdsList.isEmpty() || !snapshotIdsList.isAutoConstruct()) {
            int snapshotIdsListIndex = 1;
            for (Object snapshotIdsListValue : snapshotIdsList) {
                if (snapshotIdsListValue != null) {
                    request.addParameter("SnapshotId." + snapshotIdsListIndex, StringUtils.fromString((String)snapshotIdsListValue));
                }
                ++snapshotIdsListIndex;
            }
        }
        if (!(ownerIdsList = (SdkInternalList)describeSnapshotsRequest.getOwnerIds()).isEmpty() || !ownerIdsList.isAutoConstruct()) {
            int ownerIdsListIndex = 1;
            for (Object ownerIdsListValue : ownerIdsList) {
                if (ownerIdsListValue != null) {
                    request.addParameter("Owner." + ownerIdsListIndex, StringUtils.fromString((String)ownerIdsListValue));
                }
                ++ownerIdsListIndex;
            }
        }
        if (!(restorableByUserIdsList = (SdkInternalList)describeSnapshotsRequest.getRestorableByUserIds()).isEmpty() || !restorableByUserIdsList.isAutoConstruct()) {
            int restorableByUserIdsListIndex = 1;
            for (String restorableByUserIdsListValue : restorableByUserIdsList) {
                if (restorableByUserIdsListValue != null) {
                    request.addParameter("RestorableBy." + restorableByUserIdsListIndex, StringUtils.fromString((String)restorableByUserIdsListValue));
                }
                ++restorableByUserIdsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeSnapshotsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeSnapshotsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeSnapshotsRequest.getNextToken()));
        }
        if (describeSnapshotsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeSnapshotsRequest.getMaxResults()));
        }
        return request;
    }
}

