/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeSecurityGroupsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeSecurityGroupsRequestMarshaller
implements Marshaller<Request<DescribeSecurityGroupsRequest>, DescribeSecurityGroupsRequest> {
    public Request<DescribeSecurityGroupsRequest> marshall(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        SdkInternalList filtersList;
        SdkInternalList groupIdsList;
        if (describeSecurityGroupsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeSecurityGroupsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeSecurityGroups");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList groupNamesList = (SdkInternalList)describeSecurityGroupsRequest.getGroupNames();
        if (!groupNamesList.isEmpty() || !groupNamesList.isAutoConstruct()) {
            int groupNamesListIndex = 1;
            for (String groupNamesListValue : groupNamesList) {
                if (groupNamesListValue != null) {
                    request.addParameter("GroupName." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
                }
                ++groupNamesListIndex;
            }
        }
        if (!(groupIdsList = (SdkInternalList)describeSecurityGroupsRequest.getGroupIds()).isEmpty() || !groupIdsList.isAutoConstruct()) {
            int groupIdsListIndex = 1;
            for (String groupIdsListValue : groupIdsList) {
                if (groupIdsListValue != null) {
                    request.addParameter("GroupId." + groupIdsListIndex, StringUtils.fromString((String)groupIdsListValue));
                }
                ++groupIdsListIndex;
            }
        }
        if (!(filtersList = (SdkInternalList)describeSecurityGroupsRequest.getFilters()).isEmpty() || !filtersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter filtersListValue : filtersList) {
                SdkInternalList valuesList;
                if (filtersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)filtersListValue.getName()));
                }
                if (!(valuesList = (SdkInternalList)filtersListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

