/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.PurchaseRequest;
import com.amazonaws.services.ec2.model.transform.PurchaseScheduledInstancesRequestMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class PurchaseScheduledInstancesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<PurchaseScheduledInstancesRequest> {
    private String clientToken;
    private ListWithAutoConstructFlag<PurchaseRequest> purchaseRequests;

    public String getClientToken() {
        return this.clientToken;
    }

    public void setClientToken(String clientToken) {
        this.clientToken = clientToken;
    }

    public PurchaseScheduledInstancesRequest withClientToken(String clientToken) {
        this.clientToken = clientToken;
        return this;
    }

    public List<PurchaseRequest> getPurchaseRequests() {
        if (this.purchaseRequests == null) {
            this.purchaseRequests = new ListWithAutoConstructFlag();
            this.purchaseRequests.setAutoConstruct(true);
        }
        return this.purchaseRequests;
    }

    public void setPurchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
        if (purchaseRequests == null) {
            this.purchaseRequests = null;
            return;
        }
        ListWithAutoConstructFlag purchaseRequestsCopy = new ListWithAutoConstructFlag(purchaseRequests.size());
        purchaseRequestsCopy.addAll(purchaseRequests);
        this.purchaseRequests = purchaseRequestsCopy;
    }

    public PurchaseScheduledInstancesRequest withPurchaseRequests(PurchaseRequest ... purchaseRequests) {
        if (this.getPurchaseRequests() == null) {
            this.setPurchaseRequests(new ArrayList<PurchaseRequest>(purchaseRequests.length));
        }
        for (PurchaseRequest value : purchaseRequests) {
            this.getPurchaseRequests().add(value);
        }
        return this;
    }

    public PurchaseScheduledInstancesRequest withPurchaseRequests(Collection<PurchaseRequest> purchaseRequests) {
        if (purchaseRequests == null) {
            this.purchaseRequests = null;
        } else {
            ListWithAutoConstructFlag purchaseRequestsCopy = new ListWithAutoConstructFlag(purchaseRequests.size());
            purchaseRequestsCopy.addAll(purchaseRequests);
            this.purchaseRequests = purchaseRequestsCopy;
        }
        return this;
    }

    @Override
    public Request<PurchaseScheduledInstancesRequest> getDryRunRequest() {
        Request<PurchaseScheduledInstancesRequest> request = new PurchaseScheduledInstancesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getClientToken() != null) {
            sb.append("ClientToken: " + this.getClientToken() + ",");
        }
        if (this.getPurchaseRequests() != null) {
            sb.append("PurchaseRequests: " + this.getPurchaseRequests());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getClientToken() == null ? 0 : this.getClientToken().hashCode());
        hashCode = 31 * hashCode + (this.getPurchaseRequests() == null ? 0 : this.getPurchaseRequests().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseScheduledInstancesRequest)) {
            return false;
        }
        PurchaseScheduledInstancesRequest other = (PurchaseScheduledInstancesRequest)obj;
        if (other.getClientToken() == null ^ this.getClientToken() == null) {
            return false;
        }
        if (other.getClientToken() != null && !other.getClientToken().equals(this.getClientToken())) {
            return false;
        }
        if (other.getPurchaseRequests() == null ^ this.getPurchaseRequests() == null) {
            return false;
        }
        return other.getPurchaseRequests() == null || other.getPurchaseRequests().equals(this.getPurchaseRequests());
    }

    public PurchaseScheduledInstancesRequest clone() {
        return (PurchaseScheduledInstancesRequest)super.clone();
    }
}

